/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.periodical;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Provider;
import org.graylog2.configuration.ElasticsearchConfiguration;
import org.graylog2.indexer.IndexSetRegistry;
import org.graylog2.indexer.cluster.Cluster;
import org.graylog2.indexer.management.IndexManagementConfig;
import org.graylog2.notifications.Notification;
import org.graylog2.notifications.NotificationService;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.indexer.retention.RetentionStrategy;
import org.graylog2.plugin.periodical.Periodical;
import org.graylog2.plugin.system.NodeId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexRetentionThread
extends Periodical {
    private static final Logger LOG = LoggerFactory.getLogger(IndexRetentionThread.class);
    private final ElasticsearchConfiguration configuration;
    private final IndexSetRegistry indexSetRegistry;
    private final Cluster cluster;
    private final ClusterConfigService clusterConfigService;
    private final NodeId nodeId;
    private final NotificationService notificationService;
    private final Map<String, Provider<RetentionStrategy>> retentionStrategyMap;

    @Inject
    public IndexRetentionThread(ElasticsearchConfiguration configuration, IndexSetRegistry indexSetRegistry, Cluster cluster, ClusterConfigService clusterConfigService, NodeId nodeId, NotificationService notificationService, Map<String, Provider<RetentionStrategy>> retentionStrategyMap) {
        this.configuration = configuration;
        this.indexSetRegistry = indexSetRegistry;
        this.cluster = cluster;
        this.clusterConfigService = clusterConfigService;
        this.nodeId = nodeId;
        this.notificationService = notificationService;
        this.retentionStrategyMap = retentionStrategyMap;
    }

    @Override
    public void doRun() {
        if (!this.cluster.isConnected() || !this.cluster.isHealthy()) {
            LOG.info("Elasticsearch cluster not available, skipping index retention checks.");
            return;
        }
        IndexManagementConfig config = this.clusterConfigService.get(IndexManagementConfig.class);
        if (config == null) {
            LOG.warn("No index management configuration found, not running index retention!");
            this.retentionProblemNotification("Index Retention Problem!", "No index management configuration found, not running index retention! Please fix your index retention configuration!");
            return;
        }
        Provider<RetentionStrategy> retentionStrategyProvider = this.retentionStrategyMap.get(config.retentionStrategy());
        if (retentionStrategyProvider == null) {
            LOG.warn("Retention strategy \"{}\" not found, not running index retention!", (Object)config.retentionStrategy());
            this.retentionProblemNotification("Index Retention Problem!", "Index retention strategy " + config.retentionStrategy() + " not found! Please fix your index retention configuration!");
            return;
        }
        RetentionStrategy retentionStrategy = (RetentionStrategy)retentionStrategyProvider.get();
        this.indexSetRegistry.forEach(retentionStrategy::retain);
    }

    private void retentionProblemNotification(String title, String description) {
        Notification notification = this.notificationService.buildNow().addNode(this.nodeId.toString()).addType(Notification.Type.GENERIC).addSeverity(Notification.Severity.URGENT).addDetail("title", title).addDetail("description", description);
        this.notificationService.publishIfFirst(notification);
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    @Override
    public boolean runsForever() {
        return false;
    }

    @Override
    public boolean stopOnGracefulShutdown() {
        return true;
    }

    @Override
    public boolean masterOnly() {
        return true;
    }

    @Override
    public boolean startOnThisNode() {
        return this.configuration.performRetention();
    }

    @Override
    public boolean isDaemon() {
        return false;
    }

    @Override
    public int getInitialDelaySeconds() {
        return 0;
    }

    @Override
    public int getPeriodSeconds() {
        return (int)TimeUnit.MINUTES.toSeconds(5L);
    }
}

