/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.periodical;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import org.graylog2.configuration.ElasticsearchConfiguration;
import org.graylog2.indexer.indexset.IndexSetConfig;
import org.graylog2.indexer.indexset.IndexSetService;
import org.graylog2.indexer.management.IndexManagementConfig;
import org.graylog2.periodical.AutoValue_IndexSetsMigrationPeriodical_IndexSetMigrated;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.indexer.retention.RetentionStrategy;
import org.graylog2.plugin.indexer.retention.RetentionStrategyConfig;
import org.graylog2.plugin.indexer.rotation.RotationStrategy;
import org.graylog2.plugin.indexer.rotation.RotationStrategyConfig;
import org.graylog2.plugin.periodical.Periodical;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexSetsMigrationPeriodical
extends Periodical {
    private static final Logger LOG = LoggerFactory.getLogger(IndexSetsMigrationPeriodical.class);
    private final ElasticsearchConfiguration elasticsearchConfiguration;
    private final Map<String, Provider<RotationStrategy>> rotationStrategies;
    private final Map<String, Provider<RetentionStrategy>> retentionStrategies;
    private final IndexSetService indexSetService;
    private final ClusterConfigService clusterConfigService;

    @Inject
    public IndexSetsMigrationPeriodical(ElasticsearchConfiguration elasticsearchConfiguration, Map<String, Provider<RotationStrategy>> rotationStrategies, Map<String, Provider<RetentionStrategy>> retentionStrategies, IndexSetService indexSetService, ClusterConfigService clusterConfigService) {
        this.elasticsearchConfiguration = elasticsearchConfiguration;
        this.rotationStrategies = rotationStrategies;
        this.retentionStrategies = retentionStrategies;
        this.indexSetService = indexSetService;
        this.clusterConfigService = clusterConfigService;
    }

    @Override
    public void doRun() {
        IndexManagementConfig indexManagementConfig = this.clusterConfigService.get(IndexManagementConfig.class);
        Preconditions.checkState((indexManagementConfig != null ? 1 : 0) != 0, (Object)"Couldn't find index management configuration");
        RotationStrategyConfig rotationStrategyConfig = this.getRotationStrategyConfig(indexManagementConfig);
        RetentionStrategyConfig retentionStrategyConfig = this.getRetentionStrategyConfig(indexManagementConfig);
        IndexSetConfig indexSetConfig = IndexSetConfig.builder().title("Default index set").description("The Graylog default index set").indexPrefix(this.elasticsearchConfiguration.getIndexPrefix()).shards(this.elasticsearchConfiguration.getShards()).replicas(this.elasticsearchConfiguration.getReplicas()).rotationStrategy(rotationStrategyConfig).retentionStrategy(retentionStrategyConfig).creationDate(ZonedDateTime.now(ZoneOffset.UTC)).build();
        IndexSetConfig savedConfig = this.indexSetService.save(indexSetConfig);
        this.clusterConfigService.write(IndexSetMigrated.create());
        LOG.info("Successfully migrated index settings (database ID <{}>)", (Object)savedConfig.id());
    }

    private RetentionStrategyConfig getRetentionStrategyConfig(IndexManagementConfig indexManagementConfig) {
        String strategyName = indexManagementConfig.retentionStrategy();
        Provider<RetentionStrategy> provider = this.retentionStrategies.get(strategyName);
        Preconditions.checkState((provider != null ? 1 : 0) != 0, (Object)("Couldn't retrieve retention strategy provider for <" + strategyName + ">"));
        RetentionStrategy strategy = (RetentionStrategy)provider.get();
        Class<? extends RetentionStrategyConfig> configClass = strategy.configurationClass();
        RetentionStrategyConfig config = this.clusterConfigService.get(configClass);
        return (RetentionStrategyConfig)MoreObjects.firstNonNull((Object)config, (Object)strategy.defaultConfiguration());
    }

    private RotationStrategyConfig getRotationStrategyConfig(IndexManagementConfig indexManagementConfig) {
        String strategyName = indexManagementConfig.rotationStrategy();
        Provider<RotationStrategy> provider = this.rotationStrategies.get(strategyName);
        Preconditions.checkState((provider != null ? 1 : 0) != 0, (Object)("Couldn't retrieve rotation strategy provider for <" + strategyName + ">"));
        RotationStrategy strategy = (RotationStrategy)provider.get();
        Class<? extends RotationStrategyConfig> configClass = strategy.configurationClass();
        RotationStrategyConfig config = this.clusterConfigService.get(configClass);
        return (RotationStrategyConfig)MoreObjects.firstNonNull((Object)config, (Object)strategy.defaultConfiguration());
    }

    @Override
    public boolean runsForever() {
        return true;
    }

    @Override
    public boolean stopOnGracefulShutdown() {
        return false;
    }

    @Override
    public boolean masterOnly() {
        return true;
    }

    @Override
    public boolean startOnThisNode() {
        return this.clusterConfigService.get(IndexSetMigrated.class) == null;
    }

    @Override
    public boolean isDaemon() {
        return false;
    }

    @Override
    public int getInitialDelaySeconds() {
        return 0;
    }

    @Override
    public int getPeriodSeconds() {
        return 0;
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    @JsonAutoDetect
    static abstract class IndexSetMigrated {
        IndexSetMigrated() {
        }

        @JsonCreator
        public static IndexSetMigrated create() {
            return new AutoValue_IndexSetsMigrationPeriodical_IndexSetMigrated();
        }
    }
}

