/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.alerts;

import com.codahale.metrics.annotation.Timed;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.validation.constraints.Min;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog2.alerts.AlertService;
import org.graylog2.database.NotFoundException;
import org.graylog2.rest.models.streams.alerts.AlertListSummary;
import org.graylog2.rest.models.streams.alerts.AlertSummary;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.streams.StreamService;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

@RequiresAuthentication
@Api(value="Alerts", description="Manage stream alerts for all streams")
@Path(value="/streams/alerts")
public class AlertResource
extends RestResource {
    private static final int DEFAULT_MAX_LIST_COUNT = 300;
    private final StreamService streamService;
    private final AlertService alertService;

    @Inject
    public AlertResource(StreamService streamService, AlertService alertService) {
        this.streamService = streamService;
        this.alertService = alertService;
    }

    @GET
    @Timed
    @ApiOperation(value="Get the most recent alarms of all streams.")
    @RequiresPermissions(value={"streams:read"})
    @Produces(value={"application/json"})
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid ObjectId.")})
    public AlertListSummary listAll(@ApiParam(name="since", value="Optional parameter to define a lower date boundary. (UNIX timestamp)", required=false) @QueryParam(value="since") @DefaultValue(value="0") @Min(value=0L) int sinceTs, @ApiParam(name="limit", value="Maximum number of alerts to return.", required=false) @QueryParam(value="limit") @DefaultValue(value="300") @Min(value=1L) int limit) throws NotFoundException {
        DateTime since = new DateTime((long)sinceTs * 1000L, DateTimeZone.UTC);
        List<AlertSummary> alerts = this.streamService.loadAll().stream().filter(stream -> this.isPermitted("streams:read", stream.getId())).flatMap(stream -> this.alertService.loadRecentOfStream(stream.getId(), since, limit).stream()).map(alert -> AlertSummary.create(alert.getId(), alert.getConditionId(), alert.getStreamId(), alert.getDescription(), alert.getConditionParameters(), alert.getTriggeredAt())).collect(Collectors.toList());
        return AlertListSummary.create(alerts.size(), alerts);
    }
}

