/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system.indexer.responses;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.ZonedDateTime;
import javax.annotation.Nullable;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.graylog2.plugin.indexer.retention.RetentionStrategyConfig;
import org.graylog2.plugin.indexer.rotation.RotationStrategyConfig;
import org.graylog2.rest.resources.system.indexer.responses.IndexSetSummary;
import org.hibernate.validator.constraints.NotBlank;

final class AutoValue_IndexSetSummary
extends IndexSetSummary {
    private final String id;
    private final String title;
    private final String description;
    private final String indexPrefix;
    private final int shards;
    private final int replicas;
    private final RotationStrategyConfig rotationStrategy;
    private final RetentionStrategyConfig retentionStrategy;
    private final ZonedDateTime creationDate;

    AutoValue_IndexSetSummary(@Nullable String id, String title, @Nullable String description, String indexPrefix, int shards, int replicas, RotationStrategyConfig rotationStrategy, RetentionStrategyConfig retentionStrategy, ZonedDateTime creationDate) {
        this.id = id;
        if (title == null) {
            throw new NullPointerException("Null title");
        }
        this.title = title;
        this.description = description;
        if (indexPrefix == null) {
            throw new NullPointerException("Null indexPrefix");
        }
        this.indexPrefix = indexPrefix;
        this.shards = shards;
        this.replicas = replicas;
        if (rotationStrategy == null) {
            throw new NullPointerException("Null rotationStrategy");
        }
        this.rotationStrategy = rotationStrategy;
        if (retentionStrategy == null) {
            throw new NullPointerException("Null retentionStrategy");
        }
        this.retentionStrategy = retentionStrategy;
        if (creationDate == null) {
            throw new NullPointerException("Null creationDate");
        }
        this.creationDate = creationDate;
    }

    @Override
    @JsonProperty(value="id")
    @Nullable
    public String id() {
        return this.id;
    }

    @Override
    @JsonProperty(value="title")
    @NotBlank
    public String title() {
        return this.title;
    }

    @Override
    @JsonProperty(value="description")
    @Nullable
    public String description() {
        return this.description;
    }

    @Override
    @JsonProperty(value="index_prefix")
    @NotBlank
    public String indexPrefix() {
        return this.indexPrefix;
    }

    @Override
    @JsonProperty(value="shards")
    @Min(value=1L)
    public int shards() {
        return this.shards;
    }

    @Override
    @JsonProperty(value="replicas")
    @Min(value=0L)
    public int replicas() {
        return this.replicas;
    }

    @Override
    @JsonProperty(value="rotation_strategy")
    @NotNull
    public RotationStrategyConfig rotationStrategy() {
        return this.rotationStrategy;
    }

    @Override
    @JsonProperty(value="retention_strategy")
    @NotNull
    public RetentionStrategyConfig retentionStrategy() {
        return this.retentionStrategy;
    }

    @Override
    @JsonProperty(value="creation_date")
    @NotNull
    public ZonedDateTime creationDate() {
        return this.creationDate;
    }

    public String toString() {
        return "IndexSetSummary{id=" + this.id + ", " + "title=" + this.title + ", " + "description=" + this.description + ", " + "indexPrefix=" + this.indexPrefix + ", " + "shards=" + this.shards + ", " + "replicas=" + this.replicas + ", " + "rotationStrategy=" + this.rotationStrategy + ", " + "retentionStrategy=" + this.retentionStrategy + ", " + "creationDate=" + this.creationDate + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof IndexSetSummary) {
            IndexSetSummary that = (IndexSetSummary)o;
            return (this.id == null ? that.id() == null : this.id.equals(that.id())) && this.title.equals(that.title()) && (this.description == null ? that.description() == null : this.description.equals(that.description())) && this.indexPrefix.equals(that.indexPrefix()) && this.shards == that.shards() && this.replicas == that.replicas() && this.rotationStrategy.equals(that.rotationStrategy()) && this.retentionStrategy.equals(that.retentionStrategy()) && this.creationDate.equals(that.creationDate());
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.id == null ? 0 : this.id.hashCode();
        h *= 1000003;
        h ^= this.title.hashCode();
        h *= 1000003;
        h ^= this.description == null ? 0 : this.description.hashCode();
        h *= 1000003;
        h ^= this.indexPrefix.hashCode();
        h *= 1000003;
        h ^= this.shards;
        h *= 1000003;
        h ^= this.replicas;
        h *= 1000003;
        h ^= this.rotationStrategy.hashCode();
        h *= 1000003;
        h ^= this.retentionStrategy.hashCode();
        h *= 1000003;
        return h ^= this.creationDate.hashCode();
    }
}

