/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system.indexer.responses;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.ZonedDateTime;
import javax.annotation.Nullable;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.graylog2.indexer.indexset.IndexSetConfig;
import org.graylog2.plugin.indexer.retention.RetentionStrategyConfig;
import org.graylog2.plugin.indexer.rotation.RotationStrategyConfig;
import org.graylog2.rest.resources.system.indexer.responses.AutoValue_IndexSetSummary;
import org.hibernate.validator.constraints.NotBlank;

@JsonAutoDetect
public abstract class IndexSetSummary {
    @JsonProperty(value="id")
    @Nullable
    public abstract String id();

    @JsonProperty(value="title")
    @NotBlank
    public abstract String title();

    @JsonProperty(value="description")
    @Nullable
    public abstract String description();

    @JsonProperty(value="index_prefix")
    @NotBlank
    public abstract String indexPrefix();

    @JsonProperty(value="shards")
    @Min(value=1L)
    public abstract int shards();

    @JsonProperty(value="replicas")
    @Min(value=0L)
    public abstract int replicas();

    @JsonProperty(value="rotation_strategy")
    @NotNull
    public abstract RotationStrategyConfig rotationStrategy();

    @JsonProperty(value="retention_strategy")
    @NotNull
    public abstract RetentionStrategyConfig retentionStrategy();

    @JsonProperty(value="creation_date")
    @NotNull
    public abstract ZonedDateTime creationDate();

    @JsonCreator
    public static IndexSetSummary create(@JsonProperty(value="id") @Nullable String id, @JsonProperty(value="title") @NotBlank String title, @JsonProperty(value="description") @Nullable String description, @JsonProperty(value="index_prefix") @NotBlank String indexPrefix, @JsonProperty(value="shards") @Min(value=1L) int shards, @JsonProperty(value="replicas") @Min(value=0L) int replicas, @JsonProperty(value="rotation_strategy") @NotNull RotationStrategyConfig rotationStrategy, @JsonProperty(value="retention_strategy") @NotNull RetentionStrategyConfig retentionStrategy, @JsonProperty(value="creation_date") @NotNull ZonedDateTime creationDate) {
        return new AutoValue_IndexSetSummary(id, title, description, indexPrefix, shards, replicas, rotationStrategy, retentionStrategy, creationDate);
    }

    public static IndexSetSummary fromIndexSetConfig(IndexSetConfig indexSet) {
        return IndexSetSummary.create(indexSet.id(), indexSet.title(), indexSet.description(), indexSet.indexPrefix(), indexSet.shards(), indexSet.replicas(), indexSet.rotationStrategy(), indexSet.retentionStrategy(), indexSet.creationDate());
    }

    public IndexSetConfig toIndexSetConfig() {
        return IndexSetConfig.create(this.id(), this.title(), this.description(), this.indexPrefix(), this.shards(), this.replicas(), this.rotationStrategy(), this.retentionStrategy(), this.creationDate());
    }
}

