/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.alerts;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.graylog2.alerts.Alert;
import org.graylog2.alerts.AutoValue_AlertImpl;
import org.graylog2.database.CollectionName;
import org.graylog2.plugin.alarms.AlertCondition;
import org.joda.time.DateTime;
import org.mongojack.Id;
import org.mongojack.ObjectId;

@JsonAutoDetect
@CollectionName(value="alerts")
public abstract class AlertImpl
implements Alert {
    static final String FIELD_ID = "_id";
    static final String FIELD_CONDITION_ID = "condition_id";
    static final String FIELD_STREAM_ID = "stream_id";
    static final String FIELD_DESCRIPTION = "description";
    static final String FIELD_CONDITION_PARAMETERS = "condition_parameters";
    static final String FIELD_TRIGGERED_AT = "triggered_at";
    static final String FIELD_RESOLVED_AT = "resolved_at";
    static final String FIELD_IS_INTERVAL = "is_interval";

    @Override
    @JsonProperty(value="_id")
    @ObjectId
    @Id
    public abstract String getId();

    @Override
    @JsonProperty(value="stream_id")
    public abstract String getStreamId();

    @Override
    @JsonProperty(value="condition_id")
    public abstract String getConditionId();

    @Override
    @JsonProperty(value="triggered_at")
    public abstract DateTime getTriggeredAt();

    @Override
    @JsonProperty(value="resolved_at")
    @Nullable
    public abstract DateTime getResolvedAt();

    @Override
    @JsonProperty(value="description")
    public abstract String getDescription();

    @Override
    @JsonProperty(value="condition_parameters")
    public abstract Map<String, Object> getConditionParameters();

    @Override
    @JsonProperty(value="is_interval")
    public abstract boolean isInterval();

    static Builder builder() {
        return new AutoValue_AlertImpl.Builder();
    }

    public abstract Builder toBuilder();

    @JsonCreator
    public static AlertImpl create(@JsonProperty(value="_id") @ObjectId @Id String id, @JsonProperty(value="stream_id") String streamId, @JsonProperty(value="condition_id") String conditionId, @JsonProperty(value="triggered_at") DateTime triggeredAt, @JsonProperty(value="resolved_at") @Nullable DateTime resolvedAt, @JsonProperty(value="description") String description, @JsonProperty(value="condition_parameters") Map<String, Object> conditionParameters, @JsonProperty(value="is_interval") boolean isInterval) {
        return AlertImpl.builder().id(id).streamId(streamId).conditionId(conditionId).triggeredAt(triggeredAt).resolvedAt(resolvedAt).description(description).conditionParameters(conditionParameters).interval(isInterval).build();
    }

    public static AlertImpl fromCheckResult(AlertCondition.CheckResult checkResult) {
        return AlertImpl.create(new org.bson.types.ObjectId().toHexString(), checkResult.getTriggeredCondition().getStream().getId(), checkResult.getTriggeredCondition().getId(), checkResult.getTriggeredAt(), null, checkResult.getResultDescription(), (Map<String, Object>)ImmutableMap.copyOf(checkResult.getTriggeredCondition().getParameters()), true);
    }

    public static interface Builder {
        public Builder id(String var1);

        public Builder streamId(String var1);

        public Builder conditionId(String var1);

        public Builder triggeredAt(DateTime var1);

        public Builder resolvedAt(DateTime var1);

        public Builder description(String var1);

        public Builder conditionParameters(Map<String, Object> var1);

        public Builder interval(boolean var1);

        public AlertImpl build();
    }
}

