/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.alerts.types;

import com.google.common.collect.Lists;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import org.graylog2.Configuration;
import org.graylog2.alerts.AbstractAlertCondition;
import org.graylog2.indexer.InvalidRangeFormatException;
import org.graylog2.indexer.results.ResultMessage;
import org.graylog2.indexer.results.SearchResult;
import org.graylog2.indexer.searches.Searches;
import org.graylog2.indexer.searches.Sorting;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.MessageSummary;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.alarms.AlertCondition;
import org.graylog2.plugin.configuration.ConfigurationRequest;
import org.graylog2.plugin.configuration.fields.ConfigurationField;
import org.graylog2.plugin.configuration.fields.TextField;
import org.graylog2.plugin.indexer.searches.timeranges.InvalidRangeParametersException;
import org.graylog2.plugin.indexer.searches.timeranges.RelativeRange;
import org.graylog2.plugin.streams.Stream;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldContentValueAlertCondition
extends AbstractAlertCondition {
    private static final Logger LOG = LoggerFactory.getLogger(FieldContentValueAlertCondition.class);
    private final Searches searches;
    private final Configuration configuration;
    private final String field;
    private final String value;

    @AssistedInject
    public FieldContentValueAlertCondition(Searches searches, Configuration configuration, @Assisted Stream stream, @Nullable @Assisted(value="id") String id, @Assisted DateTime createdAt, @Assisted(value="userid") String creatorUserId, @Assisted Map<String, Object> parameters, @Assisted(value="title") @Nullable String title) {
        super(stream, id, AbstractAlertCondition.Type.FIELD_CONTENT_VALUE.toString(), createdAt, creatorUserId, parameters, title);
        this.searches = searches;
        this.configuration = configuration;
        this.field = (String)parameters.get("field");
        this.value = (String)parameters.get("value");
    }

    @Override
    public AbstractAlertCondition.CheckResult runCheck() {
        String filter = "streams:" + this.stream.getId();
        String query = this.field + ":\"" + this.value + "\"";
        Integer backlogSize = this.getBacklog();
        boolean backlogEnabled = false;
        int searchLimit = 1;
        if (backlogSize != null && backlogSize > 0) {
            backlogEnabled = true;
            searchLimit = backlogSize;
        }
        try {
            ArrayList summaries;
            SearchResult result = this.searches.search(query, filter, RelativeRange.create(this.configuration.getAlertCheckInterval()), searchLimit, 0, new Sorting("timestamp", Sorting.Direction.DESC));
            if (backlogEnabled) {
                summaries = Lists.newArrayListWithCapacity((int)result.getResults().size());
                for (ResultMessage resultMessage : result.getResults()) {
                    Message msg = resultMessage.getMessage();
                    summaries.add(new MessageSummary(resultMessage.getIndex(), msg));
                }
            } else {
                summaries = Collections.emptyList();
            }
            long count = result.getTotalResults();
            String resultDescription = "Stream received messages matching <" + query + "> (Current grace time: " + this.grace + " minutes)";
            if (count > 0L) {
                LOG.debug("Alert check <{}> found [{}] messages.", (Object)this.id, (Object)count);
                return new AbstractAlertCondition.CheckResult(true, this, resultDescription, Tools.nowUTC(), summaries);
            }
            LOG.debug("Alert check <{}> returned no results.", (Object)this.id);
            return new AbstractAlertCondition.NegativeCheckResult();
        }
        catch (InvalidRangeParametersException e) {
            LOG.error("Invalid timerange.", (Throwable)e);
            return null;
        }
        catch (InvalidRangeFormatException e) {
            LOG.error("Invalid timerange format.", (Throwable)e);
            return null;
        }
    }

    @Override
    public String getDescription() {
        return "field: " + this.field + ", value: " + this.value + ", grace: " + this.grace + ", repeat notifications: " + this.repeatNotifications;
    }

    public static class Descriptor
    extends AlertCondition.Descriptor {
        public Descriptor() {
            super("Field Content Alert Condition", "https://www.graylog.org/", "This condition is triggered when the content of messages is equal to a defined value.");
        }
    }

    public static class Config
    implements AlertCondition.Config {
        @Override
        public ConfigurationRequest getRequestedConfiguration() {
            ConfigurationRequest configurationRequest = ConfigurationRequest.createWithFields(new TextField("field", "Field", "", "Field name that should be checked", ConfigurationField.Optional.NOT_OPTIONAL), new TextField("value", "Value", "", "Value that the field should be checked against", ConfigurationField.Optional.NOT_OPTIONAL));
            configurationRequest.addFields(AbstractAlertCondition.getDefaultConfigurationFields());
            return configurationRequest;
        }
    }

    public static interface Factory
    extends AlertCondition.Factory {
        @Override
        public FieldContentValueAlertCondition create(Stream var1, @Assisted(value="id") String var2, DateTime var3, @Assisted(value="userid") String var4, Map<String, Object> var5, @Assisted(value="title") @Nullable String var6);

        @Override
        public Config config();

        @Override
        public Descriptor descriptor();
    }
}

