/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.indices.jobs;

import com.github.joschi.jadconfig.util.Duration;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import javax.inject.Named;
import org.graylog2.indexer.indices.Indices;
import org.graylog2.shared.system.activities.Activity;
import org.graylog2.shared.system.activities.ActivityWriter;
import org.graylog2.system.jobs.SystemJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptimizeIndexJob
extends SystemJob {
    private static final Logger LOG = LoggerFactory.getLogger(OptimizeIndexJob.class);
    private final Indices indices;
    private final ActivityWriter activityWriter;
    private final Duration indexOptimizationTimeout;
    private final int indexOptimizationJobs;
    private final String index;
    private final int maxNumSegments;

    @AssistedInject
    public OptimizeIndexJob(Indices indices, ActivityWriter activityWriter, @Named(value="elasticsearch_index_optimization_timeout") Duration indexOptimizationTimeout, @Named(value="elasticsearch_index_optimization_jobs") int indexOptimizationJobs, @Assisted String index, @Assisted int maxNumSegments) {
        this.indices = indices;
        this.activityWriter = activityWriter;
        this.indexOptimizationTimeout = indexOptimizationTimeout;
        this.indexOptimizationJobs = indexOptimizationJobs;
        this.index = index;
        this.maxNumSegments = maxNumSegments;
    }

    @Override
    public void execute() {
        String msg = "Optimizing index <" + this.index + ">.";
        this.activityWriter.write(new Activity(msg, OptimizeIndexJob.class));
        LOG.info(msg);
        this.indices.optimizeIndex(this.index, this.maxNumSegments, this.indexOptimizationTimeout);
    }

    @Override
    public void requestCancel() {
    }

    @Override
    public int getProgress() {
        return 0;
    }

    @Override
    public int maxConcurrency() {
        return this.indexOptimizationJobs;
    }

    @Override
    public boolean providesProgress() {
        return false;
    }

    @Override
    public boolean isCancelable() {
        return false;
    }

    @Override
    public String getDescription() {
        return "Optimizes an index for read performance.";
    }

    @Override
    public String getClassName() {
        return this.getClass().getCanonicalName();
    }

    @Override
    public String getInfo() {
        return "Optimizing index " + this.index + ".";
    }

    public static interface Factory {
        public OptimizeIndexJob create(String var1, int var2);
    }
}

