/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.results;

import java.util.List;
import javax.annotation.Nullable;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.metrics.cardinality.Cardinality;
import org.elasticsearch.search.aggregations.metrics.stats.extended.ExtendedStats;
import org.elasticsearch.search.aggregations.metrics.valuecount.ValueCount;
import org.graylog2.indexer.results.IndexQueryResult;
import org.graylog2.indexer.results.ResultMessage;

public class FieldStatsResult
extends IndexQueryResult {
    @Nullable
    private final ValueCount valueCount;
    @Nullable
    private final ExtendedStats extendedStats;
    @Nullable
    private final Cardinality cardinality;
    private List<ResultMessage> searchHits;

    public FieldStatsResult(@Nullable ValueCount valueCount, @Nullable ExtendedStats extendedStats, @Nullable Cardinality cardinality, SearchHits hits, String query, BytesReference source, TimeValue took) {
        super(query, source, took);
        this.valueCount = valueCount;
        this.extendedStats = extendedStats;
        this.cardinality = cardinality;
        this.searchHits = this.buildResults(hits);
    }

    public long getCount() {
        if (this.valueCount != null) {
            return this.valueCount.getValue();
        }
        if (this.extendedStats != null) {
            return this.extendedStats.getCount();
        }
        return Long.MIN_VALUE;
    }

    public double getSum() {
        return this.extendedStats != null ? this.extendedStats.getSum() : Double.NaN;
    }

    public double getSumOfSquares() {
        return this.extendedStats != null ? this.extendedStats.getSumOfSquares() : Double.NaN;
    }

    public double getMean() {
        return this.extendedStats != null ? this.extendedStats.getAvg() : Double.NaN;
    }

    public double getMin() {
        return this.extendedStats != null ? this.extendedStats.getMin() : Double.NaN;
    }

    public double getMax() {
        return this.extendedStats != null ? this.extendedStats.getMax() : Double.NaN;
    }

    public double getVariance() {
        return this.extendedStats != null ? this.extendedStats.getVariance() : Double.NaN;
    }

    public double getStdDeviation() {
        return this.extendedStats != null ? this.extendedStats.getStdDeviation() : Double.NaN;
    }

    public long getCardinality() {
        return this.cardinality != null ? this.cardinality.getValue() : Long.MIN_VALUE;
    }

    public List<ResultMessage> getSearchHits() {
        return this.searchHits;
    }
}

