/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import javax.inject.Inject;
import org.graylog2.database.NotFoundException;
import org.graylog2.inputs.Input;
import org.graylog2.inputs.InputService;
import org.graylog2.plugin.IOState;
import org.graylog2.plugin.inputs.MessageInput;
import org.graylog2.plugin.system.NodeId;
import org.graylog2.rest.models.system.inputs.responses.InputCreated;
import org.graylog2.rest.models.system.inputs.responses.InputDeleted;
import org.graylog2.shared.inputs.InputLauncher;
import org.graylog2.shared.inputs.InputRegistry;
import org.graylog2.shared.inputs.NoSuchInputTypeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputEventListener {
    private static final Logger LOG = LoggerFactory.getLogger(InputEventListener.class);
    private final InputLauncher inputLauncher;
    private final InputRegistry inputRegistry;
    private final InputService inputService;
    private final NodeId nodeId;

    @Inject
    public InputEventListener(EventBus eventBus, InputLauncher inputLauncher, InputRegistry inputRegistry, InputService inputService, NodeId nodeId) {
        this.inputLauncher = inputLauncher;
        this.inputRegistry = inputRegistry;
        this.inputService = inputService;
        this.nodeId = nodeId;
        eventBus.register((Object)this);
    }

    @Subscribe
    public void inputCreated(InputCreated inputCreatedEvent) {
        MessageInput messageInput;
        Input input;
        LOG.debug("Input created/changed: " + inputCreatedEvent.id());
        try {
            input = this.inputService.find(inputCreatedEvent.id());
        }
        catch (NotFoundException e) {
            LOG.warn("Received InputCreated event but could not find Input: ", (Throwable)e);
            return;
        }
        IOState<MessageInput> inputState = this.inputRegistry.getInputState(inputCreatedEvent.id());
        if (inputState != null) {
            this.inputRegistry.remove(inputState);
        }
        if (!input.isGlobal().booleanValue() && !this.nodeId.toString().equals(input.getNodeId())) {
            return;
        }
        try {
            messageInput = this.inputService.getMessageInput(input);
            messageInput.initialize();
        }
        catch (NoSuchInputTypeException e) {
            LOG.warn("Newly created input is of invalid type: " + input.getType(), (Throwable)e);
            return;
        }
        IOState<MessageInput> newInputState = this.inputLauncher.launch(messageInput);
        this.inputRegistry.add(newInputState);
    }

    @Subscribe
    public void inputDeleted(InputDeleted inputDeletedEvent) {
        LOG.debug("Input deleted: " + inputDeletedEvent.id());
        IOState<MessageInput> inputState = this.inputRegistry.getInputState(inputDeletedEvent.id());
        if (inputState != null) {
            this.inputRegistry.remove(inputState);
        }
    }
}

