/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.lookup;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.inject.assistedinject.Assisted;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import org.graylog2.lookup.MongoLutCacheService;
import org.graylog2.lookup.MongoLutDataAdapterService;
import org.graylog2.lookup.dto.CacheDto;
import org.graylog2.lookup.dto.DataAdapterDto;
import org.graylog2.lookup.dto.LookupTableDto;

public class DtoLoader {
    private final Map<String, CacheDto> caches;
    private final Map<String, DataAdapterDto> dataAdapters;

    @Inject
    DtoLoader(@Assisted Collection<LookupTableDto> lookupTableDtos, MongoLutCacheService cacheService, MongoLutDataAdapterService dataAdapterService) {
        ImmutableSet.Builder cacheIds = ImmutableSet.builder();
        ImmutableSet.Builder adapterIds = ImmutableSet.builder();
        lookupTableDtos.forEach(dto -> {
            cacheIds.add((Object)dto.cacheId());
            adapterIds.add((Object)dto.dataAdapterId());
        });
        this.caches = Maps.uniqueIndex(cacheService.findByIds((Set<String>)cacheIds.build()), CacheDto::id);
        this.dataAdapters = Maps.uniqueIndex(dataAdapterService.findByIds((Set<String>)adapterIds.build()), DataAdapterDto::id);
    }

    Optional<CacheDto> getCacheDto(String id) {
        return Optional.ofNullable(this.caches.get(id));
    }

    Optional<DataAdapterDto> getDataAdapterDto(String id) {
        return Optional.ofNullable(this.dataAdapters.get(id));
    }

    static interface Factory {
        public DtoLoader create(Collection<LookupTableDto> var1);
    }
}

