/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.lookup;

import com.google.inject.assistedinject.Assisted;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import org.graylog2.lookup.DtoLoader;
import org.graylog2.lookup.LookupTable;
import org.graylog2.lookup.dto.CacheDto;
import org.graylog2.lookup.dto.DataAdapterDto;
import org.graylog2.lookup.dto.LookupTableDto;
import org.graylog2.plugin.lookup.LookupCache;
import org.graylog2.plugin.lookup.LookupDataAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LookupTableCreator {
    private static final Logger LOG = LoggerFactory.getLogger(LookupTableCreator.class);
    private final DtoLoader dtoLoader;
    private final Map<String, LookupCache.Factory> cacheFactories;
    private final Map<String, LookupDataAdapter.Factory> adapterFactories;

    @Inject
    LookupTableCreator(@Assisted Collection<LookupTableDto> dtos, DtoLoader.Factory dtoLoaderFactory, Map<String, LookupCache.Factory> cacheFactories, Map<String, LookupDataAdapter.Factory> adapterFactories) {
        this.dtoLoader = dtoLoaderFactory.create(dtos);
        this.cacheFactories = cacheFactories;
        this.adapterFactories = adapterFactories;
    }

    Optional<LookupTable> createLookupTable(LookupTableDto dto) {
        Optional<LookupCache> cache = this.createCache(dto);
        Optional<LookupDataAdapter> dataAdapter = this.createDataAdapter(dto);
        if (!cache.isPresent() || !dataAdapter.isPresent()) {
            return Optional.empty();
        }
        return this.createLookupTable(dto, cache.get(), dataAdapter.get());
    }

    Optional<LookupTable> createLookupTable(LookupTableDto dto, LookupCache cache, LookupDataAdapter dataAdapter) {
        LookupTable lookupTable = LookupTable.builder().id(dto.id()).name(dto.name()).title(dto.title()).description(dto.description()).cache(cache).dataAdapter(dataAdapter).build();
        lookupTable.cache().setLookupTable(lookupTable);
        lookupTable.dataAdapter().setLookupTable(lookupTable);
        return Optional.of(lookupTable);
    }

    Optional<LookupCache> createCache(LookupTableDto dto) {
        Optional<CacheDto> cacheDtoOptional = this.dtoLoader.getCacheDto(dto.cacheId());
        if (!cacheDtoOptional.isPresent()) {
            LOG.warn("Missing lookup cache configuration for ID {} in lookup table {}.", (Object)dto.cacheId(), (Object)dto.name());
            return Optional.empty();
        }
        CacheDto cacheDto = cacheDtoOptional.get();
        return this.getCacheFactory(dto.name(), cacheDto).map(factory -> factory.create(cacheDto.config()));
    }

    Optional<LookupDataAdapter> createDataAdapter(LookupTableDto dto) {
        Optional<DataAdapterDto> adapterDtoOptional = this.dtoLoader.getDataAdapterDto(dto.dataAdapterId());
        if (!adapterDtoOptional.isPresent()) {
            LOG.warn("Missing lookup data adapter configuration for ID {} in lookup table {}.", (Object)dto.dataAdapterId(), (Object)dto.name());
            return Optional.empty();
        }
        DataAdapterDto adapterDto = adapterDtoOptional.get();
        return this.getDataAdapterFactory(dto.name(), adapterDto).map(factory -> factory.create(adapterDto.config()));
    }

    private Optional<LookupCache.Factory> getCacheFactory(String lutName, CacheDto cacheDto) {
        LookupCache.Factory cacheFactory = this.cacheFactories.get(cacheDto.config().type());
        if (cacheFactory == null) {
            LOG.warn("Missing lookup cache implementation for type {} in lookup table {}.", (Object)cacheDto.config().type(), (Object)lutName);
            return Optional.empty();
        }
        return Optional.of(cacheFactory);
    }

    private Optional<LookupDataAdapter.Factory> getDataAdapterFactory(String lutName, DataAdapterDto adapterDto) {
        LookupDataAdapter.Factory adapterFactory = this.adapterFactories.get(adapterDto.config().type());
        if (adapterFactory == null) {
            LOG.warn("Missing lookup data adapter implementation for type {} in lookup table {}.", (Object)adapterDto.config().type(), (Object)lutName);
            return Optional.empty();
        }
        return Optional.of(adapterFactory);
    }

    static interface Factory {
        public LookupTableCreator create(Collection<LookupTableDto> var1);
    }
}

