/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.lookup;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.graylog2.lookup.LookupTable;
import org.graylog2.lookup.LookupTableCreator;
import org.graylog2.lookup.MongoLutCacheService;
import org.graylog2.lookup.MongoLutDataAdapterService;
import org.graylog2.lookup.MongoLutService;
import org.graylog2.lookup.dto.CacheDto;
import org.graylog2.lookup.dto.DataAdapterDto;
import org.graylog2.lookup.dto.LookupTableDto;
import org.graylog2.lookup.events.LookupTablesDeleted;
import org.graylog2.lookup.events.LookupTablesUpdated;
import org.graylog2.plugin.lookup.LookupCache;
import org.graylog2.plugin.lookup.LookupDataAdapter;
import org.graylog2.plugin.lookup.LookupResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class LookupTableService {
    private static final Logger LOG = LoggerFactory.getLogger(LookupTableService.class);
    private final MongoLutService mongoLutService;
    private final MongoLutCacheService cacheService;
    private final MongoLutDataAdapterService dataAdapterService;
    private final LookupTableCreator.Factory tableCreatorFactory;
    private final ConcurrentMap<String, LookupTable> lookupTables = new ConcurrentHashMap<String, LookupTable>();

    @Inject
    public LookupTableService(MongoLutService mongoLutService, MongoLutCacheService cacheService, MongoLutDataAdapterService dataAdapterService, LookupTableCreator.Factory tableCreatorFactory, EventBus serverEventBus) {
        this.mongoLutService = mongoLutService;
        this.cacheService = cacheService;
        this.dataAdapterService = dataAdapterService;
        this.tableCreatorFactory = tableCreatorFactory;
        this.initialize();
        serverEventBus.register((Object)this);
    }

    private void activateTable(String name, @Nullable LookupTable existingTable, LookupTable newTable) {
        newTable.dataAdapter().start();
        this.lookupTables.put(name, newTable);
        if (existingTable != null && !Objects.equals(existingTable.dataAdapter(), newTable.dataAdapter())) {
            existingTable.dataAdapter().stop();
        }
    }

    private void initialize() {
        Collection<LookupTableDto> lookupTableDtos = this.mongoLutService.findAll();
        LookupTableCreator tableCreator = this.tableCreatorFactory.create(lookupTableDtos);
        lookupTableDtos.forEach(dto -> {
            Optional<LookupTable> optionalLookupTable = tableCreator.createLookupTable((LookupTableDto)dto);
            if (optionalLookupTable.isPresent()) {
                LookupTable lookupTable = optionalLookupTable.get();
                this.activateTable(dto.name(), null, lookupTable);
            } else {
                LOG.warn("Not loading lookup table {} due to errors", (Object)dto.name());
            }
        });
    }

    private void updateTable(String name, @Nullable LookupTable existingTable) {
        Optional<LookupTable> tableOptional;
        LOG.debug("Updating lookup table: {}", (Object)name);
        Optional<LookupTableDto> dtoOptional = this.mongoLutService.get(name);
        if (!dtoOptional.isPresent()) {
            LOG.warn("Update event received for missing lookup table '{}', remove this event.", (Object)name);
            return;
        }
        LookupTableDto dto = dtoOptional.get();
        Optional<CacheDto> cacheDtoOptional = this.cacheService.get(dto.cacheId());
        Optional<DataAdapterDto> dataAdapterDtoOptional = this.dataAdapterService.get(dto.dataAdapterId());
        if (!cacheDtoOptional.isPresent() || !dataAdapterDtoOptional.isPresent()) {
            LOG.warn("Missing cache or data adapter for lookup table {}. Not loading lookup table.", (Object)name);
            return;
        }
        CacheDto cacheDto = cacheDtoOptional.get();
        DataAdapterDto adapterDto = dataAdapterDtoOptional.get();
        LookupTableCreator tableCreator = this.tableCreatorFactory.create(Collections.singleton(dto));
        if (existingTable == null) {
            LOG.debug("Creating new lookup table instance: {}", (Object)name);
            tableOptional = tableCreator.createLookupTable(dto);
        } else {
            LookupDataAdapter dataAdapter;
            LookupCache cache;
            if (existingTable.cache().getConfig().equals(cacheDto.config())) {
                LOG.debug("Reusing existing cache instance: {}", (Object)cacheDto.name());
                cache = existingTable.cache();
            } else {
                LOG.debug("Creating new cache instance: {}");
                Optional<LookupCache> newCache = tableCreator.createCache(dto);
                if (!newCache.isPresent()) {
                    LOG.warn("Cache creation failed. Not creating new lookup table.");
                    return;
                }
                cache = newCache.get();
            }
            if (existingTable.dataAdapter().getConfig().equals(adapterDto.config())) {
                LOG.debug("Reusing existing data adapter instance: {}", (Object)adapterDto.name());
                dataAdapter = existingTable.dataAdapter();
            } else {
                LOG.debug("Creating new data adapter instance: {}", (Object)adapterDto.name());
                Optional<LookupDataAdapter> newAdapter = tableCreator.createDataAdapter(dto);
                if (!newAdapter.isPresent()) {
                    LOG.warn("Data adapter creation failed. Not creating new lookup table.");
                    return;
                }
                dataAdapter = newAdapter.get();
            }
            tableOptional = tableCreator.createLookupTable(dto, cache, dataAdapter);
        }
        if (tableOptional.isPresent()) {
            this.activateTable(name, existingTable, tableOptional.get());
        } else {
            LOG.warn("Not loading lookup table {} due to errors", (Object)dto.name());
        }
    }

    @Subscribe
    public void handleLookupTableUpdate(LookupTablesUpdated event) {
        event.lookupTableNames().forEach(name -> this.updateTable((String)name, (LookupTable)this.lookupTables.get(name)));
    }

    @Subscribe
    public void handleLookupTableDeletion(LookupTablesDeleted event) {
        event.lookupTableNames().forEach(this.lookupTables::remove);
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    @Nullable
    private LookupTable getTable(String name) {
        LookupTable lookupTable = (LookupTable)this.lookupTables.get(name);
        if (lookupTable == null) {
            LOG.warn("Lookup table <{}> does not exist", (Object)name);
        }
        return lookupTable;
    }

    public static class Function {
        private final LookupTableService lookupTableService;
        private final String lookupTableName;
        private final Object defaultValue;

        public Function(LookupTableService lookupTableService, String lookupTableName, @Nullable Object defaultValue) {
            this.lookupTableService = lookupTableService;
            this.lookupTableName = lookupTableName;
            this.defaultValue = defaultValue;
        }

        @Nullable
        public LookupResult lookup(@Nonnull Object key) {
            LookupTable lookupTable = this.lookupTableService.getTable(this.lookupTableName);
            if (lookupTable == null) {
                return LookupResult.single(key, this.defaultValue);
            }
            LookupResult result = lookupTable.lookup(key);
            if (result == null || result.isEmpty()) {
                if (this.defaultValue == null) {
                    return LookupResult.empty();
                }
                return LookupResult.single(key, this.defaultValue);
            }
            return result;
        }
    }

    public static class Builder {
        private final LookupTableService lookupTableService;
        private String lookupTableName;
        private Object defaultValue = null;

        public Builder(LookupTableService lookupTableService) {
            this.lookupTableService = lookupTableService;
        }

        public Builder lookupTable(String name) {
            this.lookupTableName = name;
            return this;
        }

        public Builder defaultValue(Object value) {
            this.defaultValue = value;
            return this;
        }

        public Function build() {
            return new Function(this.lookupTableService, this.lookupTableName, this.defaultValue);
        }
    }
}

