/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.lookup.adapters;

import au.com.bytecode.opencsv.CSVReader;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.inject.assistedinject.Assisted;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.inject.Named;
import javax.validation.constraints.Min;
import javax.validation.constraints.Size;
import org.graylog2.lookup.adapters.;
import org.graylog2.lookup.adapters.AutoValue_CSVFileDataAdapter_FileInfo;
import org.graylog2.plugin.lookup.LookupDataAdapter;
import org.graylog2.plugin.lookup.LookupDataAdapterConfiguration;
import org.graylog2.plugin.lookup.LookupResult;
import org.hibernate.validator.constraints.NotEmpty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVFileDataAdapter
extends LookupDataAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(CSVFileDataAdapter.class);
    public static final String NAME = "csvfile";
    private final ScheduledExecutorService scheduler;
    private final Config config;
    private final AtomicReference<Map<Object, Object>> lookupRef = new AtomicReference<ImmutableMap>(ImmutableMap.of());
    private FileInfo prevFileInfo;
    private ScheduledFuture<?> future;

    @Inject
    public CSVFileDataAdapter(@Named(value="daemonScheduler") ScheduledExecutorService scheduler, @Assisted LookupDataAdapterConfiguration config) {
        super(config);
        this.scheduler = scheduler;
        this.config = (Config)config;
    }

    @Override
    public void doStart() throws Exception {
        LOG.debug("Starting CSV data adapter for file: {}", (Object)this.config.path());
        if (Strings.isNullOrEmpty((String)this.config.path())) {
            throw new IllegalStateException("File path needs to be set");
        }
        this.prevFileInfo = this.getFileInfo(this.config.path());
        this.lookupRef.set(this.parseCSVFile());
        if (this.config.checkInterval() < 1L) {
            throw new IllegalStateException("Check interval setting cannot be smaller than 1");
        }
        this.future = this.scheduler.scheduleAtFixedRate(this::checkFile, this.config.checkInterval(), this.config.checkInterval(), TimeUnit.SECONDS);
    }

    private void checkFile() {
        try {
            FileInfo newFileInfo = this.getFileInfo(this.config.path());
            if (newFileInfo.equals(this.prevFileInfo)) {
                return;
            }
            LOG.debug("CSV file {} has changed, updating data", (Object)this.config.path());
            this.lookupRef.set(this.parseCSVFile());
            this.getLookupTable().cache().purge();
            this.prevFileInfo = newFileInfo;
        }
        catch (IOException e) {
            LOG.error("Couldn't check CSV file {} for updates", (Object)this.config.path(), (Object)e);
        }
    }

    private FileInfo getFileInfo(String path) throws IOException {
        BasicFileAttributes attributes = Files.readAttributes(Paths.get(path, new String[0]), BasicFileAttributes.class, new LinkOption[0]);
        return FileInfo.builder().key(attributes.fileKey()).size(attributes.size()).modificationTime(attributes.lastModifiedTime()).build();
    }

    private Map<Object, Object> parseCSVFile() throws IOException {
        InputStream inputStream = Files.newInputStream(Paths.get(this.config.path(), new String[0]), new OpenOption[0]);
        InputStreamReader fileReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
        ImmutableMap.Builder newLookupBuilder = ImmutableMap.builder();
        try (CSVReader csvReader = new CSVReader((Reader)fileReader, this.config.separatorAsChar(), this.config.quotecharAsChar());){
            String[] next;
            int line = 0;
            int keyColumn = -1;
            int valueColumn = -1;
            block11: while ((next = csvReader.readNext()) != null) {
                if (++line == 1) {
                    int col = 0;
                    String[] stringArray = next;
                    int n = stringArray.length;
                    int n2 = 0;
                    while (true) {
                        if (n2 >= n) continue block11;
                        String column = stringArray[n2];
                        if (!Strings.isNullOrEmpty((String)column)) {
                            if (this.config.keyColumn().equals(column)) {
                                keyColumn = col;
                            } else if (this.config.valueColumn().equals(column)) {
                                valueColumn = col;
                            }
                        }
                        ++col;
                        ++n2;
                    }
                }
                if (keyColumn < 0 || valueColumn < 0) {
                    throw new IllegalStateException("Couldn't detect column number for key or value - check CSV file format");
                }
                newLookupBuilder.put((Object)next[keyColumn], (Object)next[valueColumn]);
            }
        }
        catch (Exception e) {
            LOG.error("Couldn't parse CSV file {} (settings separator=<{}> quotechar=<{}> key_column=<{}> value_column=<{}>)", new Object[]{this.config.path(), this.config.separator(), this.config.quotechar(), this.config.keyColumn(), this.config.valueColumn(), e});
        }
        return newLookupBuilder.build();
    }

    @Override
    public void doStop() throws Exception {
        LOG.debug("Stopping CSV data adapter for file: {}", (Object)this.config.path());
        if (this.future != null && !this.future.isCancelled()) {
            this.future.cancel(true);
        }
    }

    @Override
    public LookupResult doGet(Object key) {
        Object value = this.lookupRef.get().get(key);
        if (value == null) {
            return LookupResult.empty();
        }
        return LookupResult.single(key, value);
    }

    @Override
    public void set(Object key, Object value) {
    }

    public static abstract class FileInfo {
        public abstract Object key();

        public abstract long size();

        public abstract FileTime modificationTime();

        public static Builder builder() {
            return new AutoValue_CSVFileDataAdapter_FileInfo.Builder();
        }

        public static abstract class Builder {
            public abstract Builder key(Object var1);

            public abstract Builder size(long var1);

            public abstract Builder modificationTime(FileTime var1);

            public abstract FileInfo build();
        }
    }

    @JsonAutoDetect
    @JsonDeserialize(builder=.AutoValue_CSVFileDataAdapter_Config.Builder.class)
    @JsonTypeName(value="csvfile")
    public static abstract class Config
    implements LookupDataAdapterConfiguration {
        @Override
        @JsonProperty(value="type")
        public abstract String type();

        @JsonProperty(value="path")
        @NotEmpty
        public abstract String path();

        @JsonProperty(value="separator")
        @Size(min=1, max=1)
        @NotEmpty
        public abstract String separator();

        @JsonIgnore
        public char separatorAsChar() {
            return this.separator().charAt(0);
        }

        @JsonProperty(value="quotechar")
        @Size(min=1, max=1)
        @NotEmpty
        public abstract String quotechar();

        @JsonIgnore
        public char quotecharAsChar() {
            return this.quotechar().charAt(0);
        }

        @JsonProperty(value="key_column")
        @NotEmpty
        public abstract String keyColumn();

        @JsonProperty(value="value_column")
        @NotEmpty
        public abstract String valueColumn();

        @JsonProperty(value="check_interval")
        @Min(value=1L)
        public abstract long checkInterval();

        public static Builder builder() {
            return new .AutoValue_CSVFileDataAdapter_Config.Builder();
        }

        public static abstract class Builder {
            @JsonProperty(value="type")
            public abstract Builder type(String var1);

            @JsonProperty(value="path")
            public abstract Builder path(String var1);

            @JsonProperty(value="separator")
            public abstract Builder separator(String var1);

            @JsonProperty(value="quotechar")
            public abstract Builder quotechar(String var1);

            @JsonProperty(value="key_column")
            public abstract Builder keyColumn(String var1);

            @JsonProperty(value="value_column")
            public abstract Builder valueColumn(String var1);

            @JsonProperty(value="check_interval")
            public abstract Builder checkInterval(long var1);

            public abstract Config build();
        }
    }

    public static class Descriptor
    extends LookupDataAdapter.Descriptor<Config> {
        public Descriptor() {
            super(CSVFileDataAdapter.NAME, Config.class);
        }

        @Override
        public Config defaultConfiguration() {
            return Config.builder().type(CSVFileDataAdapter.NAME).path("/etc/graylog/lookup-table.csv").separator(",").quotechar("\"").keyColumn("key").valueColumn("value").checkInterval(60L).build();
        }
    }

    public static interface Factory
    extends LookupDataAdapter.Factory<CSVFileDataAdapter> {
        @Override
        public CSVFileDataAdapter create(LookupDataAdapterConfiguration var1);

        @Override
        public Descriptor getDescriptor();
    }
}

