/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.lookup.caches;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Named;
import javax.validation.constraints.Min;
import org.graylog2.lookup.caches.;
import org.graylog2.plugin.lookup.LookupCache;
import org.graylog2.plugin.lookup.LookupCacheConfiguration;
import org.graylog2.plugin.lookup.LookupDataAdapter;
import org.graylog2.plugin.lookup.LookupResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuavaLookupCache
extends LookupCache {
    private static final Logger LOG = LoggerFactory.getLogger(GuavaLookupCache.class);
    public static final String NAME = "guava_cache";
    private final LoadingCache<Object, LookupResult> cache;

    @Inject
    public GuavaLookupCache(@Assisted LookupCacheConfiguration c, @Named(value="processbuffer_processors") int processorCount) {
        super(c);
        Config config = (Config)c;
        CacheBuilder builder = CacheBuilder.newBuilder();
        builder.concurrencyLevel(processorCount).recordStats();
        builder.maximumSize((long)config.maxSize());
        if (config.expireAfterAccess() > 0L && config.expireAfterAccessUnit() != null) {
            builder.expireAfterAccess(config.expireAfterAccess(), config.expireAfterAccessUnit());
        }
        if (config.expireAfterWrite() > 0L && config.expireAfterWriteUnit() != null) {
            builder.expireAfterWrite(config.expireAfterWrite(), config.expireAfterWriteUnit());
        }
        if (config.refreshAfterWrite() > 0L && config.refreshAfterWriteUnit() != null) {
            builder.refreshAfterWrite(config.refreshAfterWrite(), config.refreshAfterWriteUnit());
        }
        this.cache = builder.build((CacheLoader)new CacheLoader<Object, LookupResult>(){

            public LookupResult load(@Nonnull Object key) throws Exception {
                return GuavaLookupCache.this.getLookupTable().dataAdapter().get(key);
            }
        });
    }

    @Override
    public LookupResult get(Object key) {
        try {
            return (LookupResult)this.cache.get(key);
        }
        catch (ExecutionException e) {
            LOG.warn("Loading value from data adapter failed, returning empty result", (Throwable)e);
            return LookupResult.empty();
        }
    }

    @Override
    public void set(Object key, Object retrievedValue) {
        LookupDataAdapter dataAdapter = this.getLookupTable().dataAdapter();
        dataAdapter.set(key, retrievedValue);
        this.cache.put(key, (Object)dataAdapter.get(key));
    }

    @Override
    public void purge() {
        this.cache.invalidateAll();
    }

    @Override
    public void purge(Object key) {
        this.cache.invalidate(key);
    }

    @JsonAutoDetect
    @JsonDeserialize(builder=.AutoValue_GuavaLookupCache_Config.Builder.class)
    @JsonTypeName(value="guava_cache")
    public static abstract class Config
    implements LookupCacheConfiguration {
        @Min(value=0L)
        @JsonProperty(value="max_size")
        public abstract int maxSize();

        @Min(value=0L)
        @JsonProperty(value="expire_after_access")
        public abstract long expireAfterAccess();

        @Nullable
        @JsonProperty(value="expire_after_access_unit")
        public abstract TimeUnit expireAfterAccessUnit();

        @Min(value=0L)
        @JsonProperty(value="expire_after_write")
        public abstract long expireAfterWrite();

        @Nullable
        @JsonProperty(value="expire_after_write_unit")
        public abstract TimeUnit expireAfterWriteUnit();

        @Min(value=0L)
        @JsonProperty(value="refresh_after_write")
        public abstract long refreshAfterWrite();

        @Nullable
        @JsonProperty(value="refresh_after_write_unit")
        public abstract TimeUnit refreshAfterWriteUnit();

        public static Builder builder() {
            return new .AutoValue_GuavaLookupCache_Config.Builder();
        }

        public static abstract class Builder {
            @JsonProperty(value="type")
            public abstract Builder type(String var1);

            @JsonProperty(value="max_size")
            public abstract Builder maxSize(int var1);

            @JsonProperty(value="expire_after_access")
            public abstract Builder expireAfterAccess(long var1);

            @JsonProperty(value="expire_after_access_unit")
            public abstract Builder expireAfterAccessUnit(@Nullable TimeUnit var1);

            @JsonProperty(value="expire_after_write")
            public abstract Builder expireAfterWrite(long var1);

            @JsonProperty(value="expire_after_write_unit")
            public abstract Builder expireAfterWriteUnit(@Nullable TimeUnit var1);

            @JsonProperty(value="refresh_after_write")
            public abstract Builder refreshAfterWrite(long var1);

            @JsonProperty(value="refresh_after_write_unit")
            public abstract Builder refreshAfterWriteUnit(@Nullable TimeUnit var1);

            public abstract Config build();
        }
    }

    public static class Descriptor
    extends LookupCache.Descriptor<Config> {
        public Descriptor() {
            super(GuavaLookupCache.NAME, Config.class);
        }

        @Override
        public Config defaultConfiguration() {
            return Config.builder().type(GuavaLookupCache.NAME).maxSize(1000).expireAfterAccess(60L).expireAfterAccessUnit(TimeUnit.SECONDS).expireAfterWrite(0L).refreshAfterWrite(0L).build();
        }
    }

    public static interface Factory
    extends LookupCache.Factory {
        public GuavaLookupCache create(LookupCacheConfiguration var1);

        @Override
        public Descriptor getDescriptor();
    }
}

