/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.plugin.lookup;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.graylog2.lookup.LookupTable;
import org.graylog2.plugin.lookup.LookupCacheConfiguration;
import org.graylog2.plugin.lookup.LookupResult;

public abstract class LookupCache {
    private String id;
    private LookupTable lookupTable;
    private final LookupCacheConfiguration config;

    protected LookupCache(LookupCacheConfiguration config) {
        this.config = config;
    }

    @Nullable
    public String id() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public LookupTable getLookupTable() {
        Preconditions.checkState((this.lookupTable != null ? 1 : 0) != 0, (Object)"lookup table cannot be null");
        return this.lookupTable;
    }

    public void setLookupTable(LookupTable lookupTable) {
        this.lookupTable = lookupTable;
    }

    public abstract LookupResult get(Object var1);

    public abstract void set(Object var1, Object var2);

    public abstract void purge();

    public abstract void purge(Object var1);

    public LookupCacheConfiguration getConfig() {
        return this.config;
    }

    public static abstract class Descriptor<C extends LookupCacheConfiguration> {
        private final String type;
        private final Class<C> configClass;

        public Descriptor(String type, Class<C> configClass) {
            this.type = type;
            this.configClass = configClass;
        }

        @JsonProperty(value="type")
        public String getType() {
            return this.type;
        }

        @JsonProperty(value="config_class")
        public Class<C> getConfigClass() {
            return this.configClass;
        }

        @JsonProperty(value="default_config")
        public abstract C defaultConfiguration();
    }

    public static interface Factory<T extends LookupCache> {
        public T create(LookupCacheConfiguration var1);

        public Descriptor getDescriptor();
    }
}

