/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.plugin.lookup;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import org.graylog2.lookup.LookupTable;
import org.graylog2.plugin.lookup.LookupDataAdapterConfiguration;
import org.graylog2.plugin.lookup.LookupResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LookupDataAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(LookupDataAdapter.class);
    private String id;
    private volatile boolean started = false;
    private volatile boolean failed = false;
    private LookupTable lookupTable;
    private ReentrantLock lock = new ReentrantLock();
    private final LookupDataAdapterConfiguration config;

    protected LookupDataAdapter(LookupDataAdapterConfiguration config) {
        this.config = config;
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isFailed() {
        return this.failed;
    }

    public void start() {
        if (this.started) {
            return;
        }
        this.lock.lock();
        try {
            this.doStart();
            this.started = true;
            this.failed = false;
        }
        catch (Exception e) {
            LOG.error("Couldn't start data adapter", (Throwable)e);
            this.failed = true;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected abstract void doStart() throws Exception;

    public void stop() {
        if (!this.started) {
            return;
        }
        this.lock.lock();
        try {
            this.doStop();
            this.started = false;
        }
        catch (Exception e) {
            LOG.error("Couldn't stop data adapter", (Throwable)e);
            this.failed = true;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected abstract void doStop() throws Exception;

    @Nullable
    public String id() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public LookupTable getLookupTable() {
        Preconditions.checkState((this.lookupTable != null ? 1 : 0) != 0, (Object)"lookup table cannot be null");
        return this.lookupTable;
    }

    public void setLookupTable(LookupTable lookupTable) {
        this.lookupTable = lookupTable;
    }

    public LookupResult get(Object key) {
        if (this.failed) {
            return LookupResult.empty();
        }
        Preconditions.checkState((boolean)this.started, (Object)"Data adapter needs to be started before it can be used");
        return this.doGet(key);
    }

    protected abstract LookupResult doGet(Object var1);

    public abstract void set(Object var1, Object var2);

    public LookupDataAdapterConfiguration getConfig() {
        return this.config;
    }

    public static abstract class Descriptor<C extends LookupDataAdapterConfiguration> {
        private final String type;
        private final Class<C> configClass;

        public Descriptor(String type, Class<C> configClass) {
            this.type = type;
            this.configClass = configClass;
        }

        @JsonProperty(value="type")
        public String getType() {
            return this.type;
        }

        @JsonProperty(value="config_class")
        public Class<C> getConfigClass() {
            return this.configClass;
        }

        @JsonProperty(value="default_config")
        public abstract C defaultConfiguration();
    }

    public static interface Factory<T extends LookupDataAdapter> {
        public T create(LookupDataAdapterConfiguration var1);

        public Descriptor getDescriptor();
    }
}

