/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.plugin.lookup;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;

public class LookupResult {
    private static final LookupResult EMPTY_LOOKUP_RESULT = new LookupResult(Collections.emptyMap());
    private final Map<Object, Object> values;
    private final long cacheTTL;
    private final boolean isEmpty;

    public static LookupResult empty() {
        return EMPTY_LOOKUP_RESULT;
    }

    public static LookupResult single(Object key, Object value) {
        return new LookupResult(Collections.singletonMap(key, value));
    }

    public LookupResult(Map<Object, Object> values) {
        this(values, Long.MAX_VALUE);
    }

    public LookupResult(Map<Object, Object> values, long cacheTTL) {
        this.values = (Map)Preconditions.checkNotNull(values);
        this.isEmpty = values.size() == 0;
        this.cacheTTL = cacheTTL;
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public long cacheTTL() {
        return this.cacheTTL;
    }

    @Nullable
    public Object get(Object key) {
        return this.values.get(key);
    }

    public Map<Object, Object> asMap() {
        return this.values;
    }
}

