/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.streams.alerts;

import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.validation.constraints.Min;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.mail.EmailException;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.alarmcallbacks.AlarmCallbackConfiguration;
import org.graylog2.alarmcallbacks.AlarmCallbackConfigurationService;
import org.graylog2.alarmcallbacks.AlarmCallbackFactory;
import org.graylog2.alerts.AbstractAlertCondition;
import org.graylog2.alerts.Alert;
import org.graylog2.alerts.AlertService;
import org.graylog2.alerts.types.DummyAlertCondition;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.database.NotFoundException;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.alarms.AlertCondition;
import org.graylog2.plugin.alarms.callbacks.AlarmCallback;
import org.graylog2.plugin.alarms.callbacks.AlarmCallbackConfigurationException;
import org.graylog2.plugin.alarms.callbacks.AlarmCallbackException;
import org.graylog2.plugin.alarms.transports.TransportConfigurationException;
import org.graylog2.plugin.streams.Stream;
import org.graylog2.rest.models.streams.alerts.AlertListSummary;
import org.graylog2.rest.models.streams.alerts.AlertSummary;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.streams.StreamService;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresAuthentication
@Api(value="Stream/Alerts", description="Manage stream alerts for a given stream")
@Path(value="/streams/{streamId}/alerts")
public class StreamAlertResource
extends RestResource {
    private static final int REST_CHECK_CACHE_SECONDS = 30;
    private static final Logger LOG = LoggerFactory.getLogger(StreamAlertResource.class);
    private static final String CACHE_KEY_BASE = "alerts";
    private static final Cache<String, Map<String, Object>> CACHE = CacheBuilder.newBuilder().expireAfterWrite(30L, TimeUnit.SECONDS).build();
    private final StreamService streamService;
    private final AlertService alertService;
    private final AlarmCallbackConfigurationService alarmCallbackConfigurationService;
    private final AlarmCallbackFactory alarmCallbackFactory;

    @Inject
    public StreamAlertResource(StreamService streamService, AlertService alertService, AlarmCallbackConfigurationService alarmCallbackConfigurationService, AlarmCallbackFactory alarmCallbackFactory) {
        this.streamService = streamService;
        this.alertService = alertService;
        this.alarmCallbackConfigurationService = alarmCallbackConfigurationService;
        this.alarmCallbackFactory = alarmCallbackFactory;
    }

    @GET
    @Timed
    @ApiOperation(value="Get the most recent alarms of this stream.")
    @Produces(value={"application/json"})
    @ApiResponses(value={@ApiResponse(code=404, message="Stream not found."), @ApiResponse(code=400, message="Invalid ObjectId.")})
    public AlertListSummary list(@ApiParam(name="streamId", value="The stream id this new alert condition belongs to.", required=true) @PathParam(value="streamId") String streamId, @ApiParam(name="since", value="Optional parameter to define a lower date boundary. (UNIX timestamp)") @QueryParam(value="since") @DefaultValue(value="0") @Min(value=0L) int sinceTs, @ApiParam(name="limit", value="Maximum number of alerts to return.") @QueryParam(value="limit") @DefaultValue(value="300") @Min(value=1L) int limit) throws NotFoundException {
        this.checkPermission("streams:read", streamId);
        DateTime since = new DateTime((long)sinceTs * 1000L, DateTimeZone.UTC);
        Stream stream = this.streamService.load(streamId);
        List<AlertSummary> conditions = this.toSummaryList(this.alertService.loadRecentOfStream(stream.getId(), since, limit));
        return AlertListSummary.create(this.alertService.totalCountForStream(streamId), conditions);
    }

    @GET
    @Timed
    @Path(value="paginated")
    @ApiOperation(value="Get the alarms of this stream, filtered by specifying limit and offset parameters.")
    @Produces(value={"application/json"})
    @ApiResponses(value={@ApiResponse(code=404, message="Stream not found."), @ApiResponse(code=400, message="Invalid ObjectId.")})
    public AlertListSummary listPaginated(@ApiParam(name="streamId", value="The stream id this new alert condition belongs to.", required=true) @PathParam(value="streamId") String streamId, @ApiParam(name="skip", value="The number of elements to skip (offset).", required=true) @QueryParam(value="skip") @DefaultValue(value="0") int skip, @ApiParam(name="limit", value="The maximum number of elements to return.", required=true) @QueryParam(value="limit") @DefaultValue(value="300") int limit) throws NotFoundException {
        this.checkPermission("streams:read", streamId);
        Stream stream = this.streamService.load(streamId);
        List<AlertSummary> conditions = this.toSummaryList(this.alertService.listForStreamId(stream.getId(), skip, limit));
        return AlertListSummary.create(this.alertService.totalCountForStream(streamId), conditions);
    }

    @GET
    @Timed
    @Path(value="check")
    @ApiOperation(value="Check for triggered alert conditions of this streams. Results cached for 30 seconds.")
    @Produces(value={"application/json"})
    @ApiResponses(value={@ApiResponse(code=404, message="Stream not found."), @ApiResponse(code=400, message="Invalid ObjectId.")})
    public Map<String, Object> checkConditions(@ApiParam(name="streamId", value="The ID of the stream to check.", required=true) @PathParam(value="streamId") String streamId) throws NotFoundException {
        Map result;
        this.checkPermission("streams:read", streamId);
        Stream stream = this.streamService.load(streamId);
        try {
            result = (Map)CACHE.get((Object)(CACHE_KEY_BASE + stream.getId()), () -> {
                List<AlertCondition> alertConditions = this.streamService.getAlertConditions(stream);
                int triggered = 0;
                ArrayList results = new ArrayList(alertConditions.size());
                for (AlertCondition alertCondition : alertConditions) {
                    HashMap<String, Object> conditionResult = new HashMap<String, Object>();
                    conditionResult.put("condition", alertCondition);
                    AlertCondition.CheckResult checkResult = alertCondition.runCheck();
                    conditionResult.put("triggered", checkResult.isTriggered());
                    if (checkResult.isTriggered()) {
                        ++triggered;
                        conditionResult.put("alert_description", checkResult.getResultDescription());
                    }
                    results.add(conditionResult);
                }
                return ImmutableMap.of((Object)"results", results, (Object)"calculated_at", (Object)Tools.getISO8601String(Tools.nowUTC()), (Object)"total_triggered", (Object)triggered);
            });
        }
        catch (ExecutionException e) {
            Throwable rootCause = Throwables.getRootCause((Throwable)e);
            LOG.error("Could not check for alerts.", rootCause);
            throw new InternalServerErrorException(rootCause);
        }
        return result;
    }

    @POST
    @Timed
    @Path(value="receivers")
    @ApiOperation(value="Add an alert receiver")
    @ApiResponses(value={@ApiResponse(code=404, message="Stream not found."), @ApiResponse(code=400, message="Invalid ObjectId."), @ApiResponse(code=400, message="Stream has no email alarm callbacks.")})
    @AuditEvent(type="server:alert_receiver:create")
    @Deprecated
    public Response addReceiver(@ApiParam(name="streamId", value="The stream id this new alert condition belongs to.", required=true) @PathParam(value="streamId") String streamId, @ApiParam(name="entity", value="Name/ID of user or email address to add as alert receiver.", required=true) @QueryParam(value="entity") String entity, @ApiParam(name="type", value="Type: users or emails", required=true) @QueryParam(value="type") String type) throws NotFoundException {
        this.checkPermission("streams:edit", streamId);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)entity) ? 1 : 0) != 0);
        if (type == null || !"users".equals(type) && !"emails".equals(type)) {
            String msg = "No such type: [" + type + "]";
            LOG.warn(msg);
            throw new BadRequestException(msg);
        }
        Stream stream = this.streamService.load(streamId);
        URI streamAlertUri = this.getUriBuilderToSelf().path(StreamAlertResource.class).build(new Object[]{streamId});
        if (stream.getAlertReceivers().containsKey(type) || stream.getAlertReceivers().get(type) != null && stream.getAlertReceivers().get(type).contains(entity)) {
            return Response.created((URI)streamAlertUri).build();
        }
        this.streamService.addAlertReceiver(stream, type, entity);
        return Response.created((URI)streamAlertUri).build();
    }

    @DELETE
    @Timed
    @Path(value="receivers")
    @ApiOperation(value="Remove an alert receiver")
    @ApiResponses(value={@ApiResponse(code=404, message="Stream not found."), @ApiResponse(code=400, message="Invalid ObjectId."), @ApiResponse(code=400, message="Stream has no email alarm callbacks.")})
    @AuditEvent(type="server:alert_receiver:delete")
    @Deprecated
    public void removeReceiver(@ApiParam(name="streamId", value="The stream id this new alert condition belongs to.", required=true) @PathParam(value="streamId") String streamId, @ApiParam(name="entity", value="Name/ID of user or email address to remove from alert receivers.", required=true) @QueryParam(value="entity") String entity, @ApiParam(name="type", value="Type: users or emails", required=true) @QueryParam(value="type") String type) throws NotFoundException {
        this.checkPermission("streams:edit", streamId);
        if (!"users".equals(type) && !"emails".equals(type)) {
            String msg = "No such type: [" + type + "]";
            LOG.warn(msg);
            throw new BadRequestException(msg);
        }
        Stream stream = this.streamService.load(streamId);
        this.streamService.removeAlertReceiver(stream, type, entity);
    }

    @POST
    @Timed
    @Path(value="sendDummyAlert")
    @ApiOperation(value="Send a test mail for a given stream")
    @ApiResponses(value={@ApiResponse(code=404, message="Stream not found."), @ApiResponse(code=400, message="Invalid ObjectId."), @ApiResponse(code=400, message="Stream has no alarm callbacks")})
    @NoAuditEvent(value="only used to test alert emails")
    public void sendDummyAlert(@ApiParam(name="streamId", value="The stream id the test alert should be sent for.", required=true) @PathParam(value="streamId") String streamId) throws TransportConfigurationException, EmailException, NotFoundException {
        this.checkPermission("streams:edit", streamId);
        Stream stream = this.streamService.load(streamId);
        DummyAlertCondition dummyAlertCondition = new DummyAlertCondition(stream, null, Tools.nowUTC(), this.getSubject().getPrincipal().toString(), Collections.emptyMap(), "Test Alert");
        try {
            AbstractAlertCondition.CheckResult checkResult = dummyAlertCondition.runCheck();
            List<AlarmCallbackConfiguration> callConfigurations = this.alarmCallbackConfigurationService.getForStream(stream);
            if (callConfigurations.size() == 0) {
                String message = "Stream has no alarm callbacks, cannot send test alert.";
                LOG.warn("Stream has no alarm callbacks, cannot send test alert.");
                throw new BadRequestException("Stream has no alarm callbacks, cannot send test alert.");
            }
            for (AlarmCallbackConfiguration configuration : callConfigurations) {
                AlarmCallback alarmCallback = this.alarmCallbackFactory.create(configuration);
                alarmCallback.call(stream, checkResult);
            }
        }
        catch (ClassNotFoundException | AlarmCallbackConfigurationException | AlarmCallbackException e) {
            throw new InternalServerErrorException(e.getMessage(), (Throwable)e);
        }
    }

    private List<AlertSummary> toSummaryList(List<Alert> alertList) {
        return alertList.stream().map(alert -> AlertSummary.create(alert.getId(), alert.getConditionId(), alert.getStreamId(), alert.getDescription(), alert.getConditionParameters(), alert.getTriggeredAt(), alert.getResolvedAt(), alert.isInterval())).collect(Collectors.toList());
    }
}

