/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system.inputs;

import com.codahale.metrics.annotation.Timed;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.database.NotFoundException;
import org.graylog2.inputs.Input;
import org.graylog2.inputs.InputService;
import org.graylog2.plugin.configuration.ConfigurationException;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.plugin.inputs.MessageInput;
import org.graylog2.rest.models.system.inputs.requests.InputCreateRequest;
import org.graylog2.rest.models.system.inputs.responses.InputCreated;
import org.graylog2.rest.models.system.inputs.responses.InputSummary;
import org.graylog2.rest.models.system.inputs.responses.InputsList;
import org.graylog2.shared.inputs.InputDescription;
import org.graylog2.shared.inputs.MessageInputFactory;
import org.graylog2.shared.inputs.NoSuchInputTypeException;
import org.graylog2.shared.rest.resources.RestResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresAuthentication
@Api(value="System/Inputs", description="Message inputs")
@Path(value="/system/inputs")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class InputsResource
extends RestResource {
    private static final Logger LOG = LoggerFactory.getLogger(InputsResource.class);
    private final InputService inputService;
    private final MessageInputFactory messageInputFactory;
    private final Map<String, InputDescription> availableInputs;

    @Inject
    public InputsResource(InputService inputService, MessageInputFactory messageInputFactory) {
        this.inputService = inputService;
        this.messageInputFactory = messageInputFactory;
        this.availableInputs = messageInputFactory.getAvailableInputs();
    }

    @GET
    @Timed
    @ApiOperation(value="Get information of a single input on this node")
    @Path(value="/{inputId}")
    @ApiResponses(value={@ApiResponse(code=404, message="No such input.")})
    public InputSummary get(@ApiParam(name="inputId", required=true) @PathParam(value="inputId") String inputId) throws NotFoundException {
        this.checkPermission("inputs:read", inputId);
        Input input = this.inputService.find(inputId);
        return this.getInputSummary(input);
    }

    @GET
    @Timed
    @ApiOperation(value="Get all inputs")
    public InputsList list() {
        Set<InputSummary> inputs = this.inputService.all().stream().filter(input -> this.isPermitted("inputs:read", input.getId())).map(this::getInputSummary).collect(Collectors.toSet());
        return InputsList.create(inputs);
    }

    @POST
    @Timed
    @ApiOperation(value="Launch input on this node", response=InputCreated.class)
    @ApiResponses(value={@ApiResponse(code=404, message="No such input type registered"), @ApiResponse(code=400, message="Missing or invalid configuration"), @ApiResponse(code=400, message="Type is exclusive and already has input running")})
    @RequiresPermissions(value={"inputs:create"})
    @AuditEvent(type="server:message_input:create")
    public Response create(@ApiParam(name="JSON body", required=true) @Valid @NotNull InputCreateRequest lr) throws ValidationException {
        try {
            MessageInput messageInput = this.messageInputFactory.create(lr, this.getCurrentUser().getName(), lr.node());
            messageInput.checkConfiguration();
            Input input = this.inputService.create(messageInput.asMap());
            String newId = this.inputService.save(input);
            URI inputUri = this.getUriBuilderToSelf().path(InputsResource.class).path("{inputId}").build(new Object[]{newId});
            return Response.created((URI)inputUri).entity((Object)InputCreated.create(newId)).build();
        }
        catch (NoSuchInputTypeException e) {
            LOG.error("There is no such input type registered.", (Throwable)e);
            throw new javax.ws.rs.NotFoundException("There is no such input type registered.", (Throwable)e);
        }
        catch (ConfigurationException e) {
            LOG.error("Missing or invalid input configuration.", (Throwable)e);
            throw new BadRequestException("Missing or invalid input configuration.", (Throwable)e);
        }
    }

    @DELETE
    @Timed
    @Path(value="/{inputId}")
    @ApiOperation(value="Terminate input on this node")
    @ApiResponses(value={@ApiResponse(code=404, message="No such input on this node.")})
    @AuditEvent(type="server:message_input:delete")
    public void terminate(@ApiParam(name="inputId", required=true) @PathParam(value="inputId") String inputId) throws NotFoundException {
        Input input = this.inputService.find(inputId);
        this.inputService.destroy(input);
    }

    @PUT
    @Timed
    @Path(value="/{inputId}")
    @ApiOperation(value="Update input on this node", response=InputCreated.class)
    @ApiResponses(value={@ApiResponse(code=404, message="No such input on this node."), @ApiResponse(code=400, message="Missing or invalid input configuration.")})
    @AuditEvent(type="server:message_input:update")
    public Response update(@ApiParam(name="JSON body", required=true) @Valid @NotNull InputCreateRequest lr, @ApiParam(name="inputId", required=true) @PathParam(value="inputId") String inputId) throws NotFoundException, NoSuchInputTypeException, ConfigurationException, ValidationException {
        this.checkPermission("inputs:edit", inputId);
        Input input = this.inputService.find(inputId);
        Map<String, Object> mergedInput = input.getFields();
        MessageInput messageInput = this.messageInputFactory.create(lr, this.getCurrentUser().getName(), lr.node());
        messageInput.checkConfiguration();
        mergedInput.putAll(messageInput.asMap());
        Input newInput = this.inputService.create(input.getId(), mergedInput);
        this.inputService.save(newInput);
        URI inputUri = this.getUriBuilderToSelf().path(InputsResource.class).path("{inputId}").build(new Object[]{input.getId()});
        return Response.created((URI)inputUri).entity((Object)InputCreated.create(input.getId())).build();
    }

    private InputSummary getInputSummary(Input input) {
        InputDescription inputDescription = this.availableInputs.get(input.getType());
        String name = inputDescription != null ? inputDescription.getName() : "Unknown Input (" + input.getType() + ")";
        return InputSummary.create(input.getTitle(), input.isGlobal(), name, input.getContentPack(), input.getId(), input.getCreatedAt(), input.getType(), input.getCreatorUserId(), input.getConfiguration(), input.getStaticFields(), input.getNodeId());
    }
}

