/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system.lookup;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.events.ClusterEventBus;
import org.graylog2.lookup.LookupTableService;
import org.graylog2.lookup.MongoLutCacheService;
import org.graylog2.lookup.MongoLutDataAdapterService;
import org.graylog2.lookup.MongoLutService;
import org.graylog2.lookup.dto.CacheDto;
import org.graylog2.lookup.dto.DataAdapterDto;
import org.graylog2.lookup.dto.LookupTableDto;
import org.graylog2.lookup.events.LookupTablesDeleted;
import org.graylog2.lookup.events.LookupTablesUpdated;
import org.graylog2.plugin.lookup.LookupCache;
import org.graylog2.plugin.lookup.LookupDataAdapter;
import org.graylog2.rest.models.PaginatedList;
import org.graylog2.rest.models.system.lookup.CacheApi;
import org.graylog2.rest.models.system.lookup.DataAdapterApi;
import org.graylog2.rest.models.system.lookup.LookupTableApi;
import org.graylog2.shared.rest.resources.RestResource;
import org.hibernate.validator.constraints.NotEmpty;
import org.mongojack.DBQuery;
import org.mongojack.DBSort;

@RequiresAuthentication
@Path(value="/system/lookup")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Api(value="System/Lookup", description="Lookup tables")
public class LookupTableResource
extends RestResource {
    private final MongoLutService lookupTableService;
    private final MongoLutDataAdapterService adapterService;
    private final MongoLutCacheService cacheService;
    private final Map<String, LookupCache.Factory> cacheTypes;
    private final Map<String, LookupDataAdapter.Factory> dataAdapterTypes;
    private LookupTableService lookupTables;
    private ClusterEventBus clusterBus;

    @Inject
    public LookupTableResource(MongoLutService lookupTableService, MongoLutDataAdapterService adapterService, MongoLutCacheService cacheService, Map<String, LookupCache.Factory> cacheTypes, Map<String, LookupDataAdapter.Factory> dataAdapterTypes, LookupTableService lookupTables, ClusterEventBus clusterBus) {
        this.lookupTableService = lookupTableService;
        this.adapterService = adapterService;
        this.cacheService = cacheService;
        this.cacheTypes = cacheTypes;
        this.dataAdapterTypes = dataAdapterTypes;
        this.lookupTables = lookupTables;
        this.clusterBus = clusterBus;
    }

    @GET
    @Path(value="data/{name}")
    @ApiOperation(value="Query a lookup table")
    public Object performLookup(@ApiParam(name="name") @PathParam(value="name") @NotEmpty String name, @ApiParam(name="key") @QueryParam(value="key") @NotEmpty String key) {
        return this.lookupTables.newBuilder().lookupTable(name).build().lookup(key);
    }

    @GET
    @Path(value="tables")
    @ApiOperation(value="List configured lookup tables")
    public LookupTablePage tables(@ApiParam(name="page") @QueryParam(value="page") @DefaultValue(value="1") int page, @ApiParam(name="per_page") @QueryParam(value="per_page") @DefaultValue(value="50") int perPage, @ApiParam(name="sort", value="The field to sort the result on", required=true, allowableValues="title") @DefaultValue(value="created_at") @QueryParam(value="sort") String sort, @ApiParam(name="order", value="The sort direction", allowableValues="asc, desc") @DefaultValue(value="desc") @QueryParam(value="order") String order, @ApiParam(name="query") @QueryParam(value="query") String query, @ApiParam(name="resolve") @QueryParam(value="resolve") @DefaultValue(value="false") boolean resolveObjects) {
        DBQuery.Query dbQuery = DBQuery.empty();
        sort = "title";
        DBSort.SortBuilder sortBuilder = "desc".equalsIgnoreCase(order) ? DBSort.desc((String)sort) : DBSort.asc((String)sort);
        PaginatedList<LookupTableDto> paginated = this.lookupTableService.findPaginated(dbQuery, sortBuilder, page, perPage);
        ImmutableSet.Builder caches = ImmutableSet.builder();
        ImmutableSet.Builder dataAdapters = ImmutableSet.builder();
        if (resolveObjects) {
            ImmutableSet.Builder cacheIds = ImmutableSet.builder();
            ImmutableSet.Builder dataAdapterIds = ImmutableSet.builder();
            paginated.forEach(dto -> {
                cacheIds.add((Object)dto.cacheId());
                dataAdapterIds.add((Object)dto.dataAdapterId());
            });
            this.cacheService.findByIds((Set<String>)cacheIds.build()).forEach(cacheDto -> caches.add((Object)CacheApi.fromDto(cacheDto)));
            this.adapterService.findByIds((Set<String>)dataAdapterIds.build()).forEach(dataAdapterDto -> dataAdapters.add((Object)DataAdapterApi.fromDto(dataAdapterDto)));
        }
        return new LookupTablePage(query, paginated.pagination(), paginated.stream().map(LookupTableApi::fromDto).collect(Collectors.toList()), (Collection<CacheApi>)caches.build(), (Collection<DataAdapterApi>)dataAdapters.build());
    }

    @GET
    @Path(value="tables/{idOrName}")
    @ApiOperation(value="Retrieve the named lookup table")
    public LookupTablePage get(@ApiParam(name="idOrName") @PathParam(value="idOrName") @NotEmpty String idOrName, @ApiParam(name="resolve") @QueryParam(value="resolve") @DefaultValue(value="false") boolean resolveObjects) {
        Optional<LookupTableDto> lookupTableDto = this.lookupTableService.get(idOrName);
        if (!lookupTableDto.isPresent()) {
            throw new NotFoundException();
        }
        LookupTableDto tableDto = lookupTableDto.get();
        Set<CacheApi> caches = Collections.emptySet();
        Set<DataAdapterApi> adapters = Collections.emptySet();
        if (resolveObjects) {
            caches = this.cacheService.findByIds(Collections.singleton(tableDto.cacheId())).stream().map(CacheApi::fromDto).collect(Collectors.toSet());
            adapters = this.adapterService.findByIds(Collections.singleton(tableDto.dataAdapterId())).stream().map(DataAdapterApi::fromDto).collect(Collectors.toSet());
        }
        PaginatedList<LookupTableApi> result = PaginatedList.singleton(LookupTableApi.fromDto(tableDto), 1, 1);
        return new LookupTablePage(null, result.pagination(), (List<LookupTableApi>)((Object)result), (Collection<CacheApi>)caches, (Collection<DataAdapterApi>)adapters);
    }

    @POST
    @Path(value="tables")
    @AuditEvent(type="server:lut_table:create")
    @ApiOperation(value="Create a new lookup table")
    public LookupTableApi createTable(@ApiParam LookupTableApi lookupTable) {
        LookupTableDto saved = this.lookupTableService.save(lookupTable.toDto());
        LookupTableApi table = LookupTableApi.fromDto(saved);
        this.clusterBus.post(LookupTablesUpdated.create(saved));
        return table;
    }

    @PUT
    @Path(value="tables")
    @AuditEvent(type="server:lut_table:update")
    @ApiOperation(value="Update the given lookup table")
    public LookupTableApi updateTable(@Valid @ApiParam LookupTableApi toUpdate) {
        LookupTableDto saved = this.lookupTableService.save(toUpdate.toDto());
        this.clusterBus.post(LookupTablesUpdated.create(saved));
        return LookupTableApi.fromDto(saved);
    }

    @DELETE
    @Path(value="tables/{idOrName}")
    @AuditEvent(type="server:lut_table:delete")
    @ApiOperation(value="Delete the lookup table")
    public LookupTableApi removeTable(@ApiParam(name="idOrName") @PathParam(value="idOrName") @NotEmpty String idOrName) {
        Optional<LookupTableDto> lookupTableDto = this.lookupTableService.get(idOrName);
        if (!lookupTableDto.isPresent()) {
            throw new NotFoundException();
        }
        this.lookupTableService.delete(idOrName);
        this.clusterBus.post(LookupTablesDeleted.create(lookupTableDto.get()));
        return LookupTableApi.fromDto(lookupTableDto.get());
    }

    @GET
    @Path(value="adapters")
    @ApiOperation(value="List available data adapters")
    public DataAdapterPage adapters(@ApiParam(name="page") @QueryParam(value="page") @DefaultValue(value="1") int page, @ApiParam(name="per_page") @QueryParam(value="per_page") @DefaultValue(value="50") int perPage, @ApiParam(name="sort", value="The field to sort the result on", required=true, allowableValues="title") @DefaultValue(value="title") @QueryParam(value="sort") String sort, @ApiParam(name="order", value="The sort direction", allowableValues="asc, desc") @DefaultValue(value="desc") @QueryParam(value="order") String order, @ApiParam(name="query") @QueryParam(value="query") String query) {
        PaginatedList<DataAdapterDto> paginated = this.adapterService.findPaginated(DBQuery.empty(), DBSort.asc((String)sort), page, perPage);
        return new DataAdapterPage(query, paginated.pagination(), paginated.stream().map(DataAdapterApi::fromDto).collect(Collectors.toList()));
    }

    @GET
    @Path(value="types/adapters")
    @ApiOperation(value="List available data adapter types")
    public Map<String, LookupDataAdapter.Descriptor> availableAdapterTypes() {
        return this.dataAdapterTypes.values().stream().map(LookupDataAdapter.Factory::getDescriptor).collect(Collectors.toMap(LookupDataAdapter.Descriptor::getType, Function.identity()));
    }

    @GET
    @Path(value="adapters/{idOrName}")
    @ApiOperation(value="List the given data adapter")
    public DataAdapterApi getAdapter(@ApiParam(name="idOrName") @PathParam(value="idOrName") @NotEmpty String idOrName) {
        Optional<DataAdapterDto> dataAdapterDto = this.adapterService.get(idOrName);
        if (dataAdapterDto.isPresent()) {
            return DataAdapterApi.fromDto(dataAdapterDto.get());
        }
        throw new NotFoundException();
    }

    @POST
    @Path(value="adapters")
    @AuditEvent(type="server:lut_adapter:create")
    @ApiOperation(value="Create a new data adapter")
    public DataAdapterApi createAdapter(@Valid @ApiParam DataAdapterApi newAdapter) {
        DataAdapterDto dto = newAdapter.toDto();
        DataAdapterDto saved = this.adapterService.save(dto);
        return DataAdapterApi.fromDto(saved);
    }

    @DELETE
    @Path(value="adapters/{idOrName}")
    @AuditEvent(type="server:lut_adapter:delete")
    @ApiOperation(value="Delete the given data adapter", notes="The data adapter cannot be in use by any lookup table, otherwise the request will fail.")
    public DataAdapterApi deleteAdapter(@ApiParam(name="idOrName") @PathParam(value="idOrName") @NotEmpty String idOrName) {
        Optional<DataAdapterDto> dataAdapterDto = this.adapterService.get(idOrName);
        if (!dataAdapterDto.isPresent()) {
            throw new NotFoundException();
        }
        DataAdapterDto dto = dataAdapterDto.get();
        boolean unused = this.lookupTableService.findByDataAdapterIds(Collections.singleton(dto.id())).isEmpty();
        if (!unused) {
            throw new BadRequestException("The adapter is still in use, cannot delete.");
        }
        this.adapterService.delete(idOrName);
        return DataAdapterApi.fromDto(dto);
    }

    @PUT
    @Path(value="adapters")
    @AuditEvent(type="server:lut_adapter:update")
    @ApiOperation(value="Update the given data adapter settings")
    public DataAdapterApi updateAdapter(@Valid @ApiParam DataAdapterApi toUpdate) {
        DataAdapterDto saved = this.adapterService.save(toUpdate.toDto());
        Collection<LookupTableDto> adapterUsages = this.lookupTableService.findByDataAdapterIds(Collections.singleton(saved.id()));
        if (!adapterUsages.isEmpty()) {
            this.clusterBus.post(LookupTablesUpdated.create(adapterUsages));
        }
        return DataAdapterApi.fromDto(saved);
    }

    @GET
    @Path(value="caches")
    @ApiOperation(value="List available caches")
    public CachesPage caches(@ApiParam(name="page") @QueryParam(value="page") @DefaultValue(value="1") int page, @ApiParam(name="per_page") @QueryParam(value="per_page") @DefaultValue(value="50") int perPage, @ApiParam(name="sort", value="The field to sort the result on", required=true, allowableValues="title") @DefaultValue(value="created_at") @QueryParam(value="sort") String sort, @ApiParam(name="order", value="The sort direction", allowableValues="asc, desc") @DefaultValue(value="desc") @QueryParam(value="order") String order, @ApiParam(name="query") @QueryParam(value="query") String query) {
        PaginatedList<CacheDto> paginated = this.cacheService.findPaginated(DBQuery.empty(), DBSort.asc((String)sort), page, perPage);
        return new CachesPage(query, paginated.pagination(), paginated.stream().map(CacheApi::fromDto).collect(Collectors.toList()));
    }

    @GET
    @Path(value="types/caches")
    @ApiOperation(value="List available caches types")
    public Map<String, LookupCache.Descriptor> availableCacheTypes() {
        return this.cacheTypes.values().stream().map(LookupCache.Factory::getDescriptor).collect(Collectors.toMap(LookupCache.Descriptor::getType, Function.identity()));
    }

    @GET
    @Path(value="caches/{idOrName}")
    @ApiOperation(value="List the given cache")
    public CacheApi getCache(@ApiParam(name="idOrName") @PathParam(value="idOrName") @NotEmpty String idOrName) {
        Optional<CacheDto> cacheDto = this.cacheService.get(idOrName);
        if (cacheDto.isPresent()) {
            return CacheApi.fromDto(cacheDto.get());
        }
        throw new NotFoundException();
    }

    @POST
    @Path(value="caches")
    @AuditEvent(type="server:lut_cache:create")
    @ApiOperation(value="Create a new cache")
    public CacheApi createCache(@ApiParam CacheApi newCache) {
        return CacheApi.fromDto(this.cacheService.save(newCache.toDto()));
    }

    @DELETE
    @Path(value="caches/{idOrName}")
    @AuditEvent(type="server:lut_cache:delete")
    @ApiOperation(value="Delete the given cache", notes="The cache cannot be in use by any lookup table, otherwise the request will fail.")
    public CacheApi deleteCache(@ApiParam(name="idOrName") @PathParam(value="idOrName") @NotEmpty String idOrName) {
        Optional<CacheDto> cacheDto = this.cacheService.get(idOrName);
        if (!cacheDto.isPresent()) {
            throw new NotFoundException();
        }
        CacheDto dto = cacheDto.get();
        boolean unused = this.lookupTableService.findByCacheIds(Collections.singleton(dto.id())).isEmpty();
        if (!unused) {
            throw new BadRequestException("The cache is still in use, cannot delete.");
        }
        this.cacheService.delete(idOrName);
        return CacheApi.fromDto(dto);
    }

    @PUT
    @Path(value="caches")
    @AuditEvent(type="server:lut_cache:update")
    @ApiOperation(value="Update the given cache settings")
    public CacheApi updateCache(@ApiParam CacheApi toUpdate) {
        CacheDto saved = this.cacheService.save(toUpdate.toDto());
        Collection<LookupTableDto> cacheUsages = this.lookupTableService.findByCacheIds(Collections.singleton(saved.id()));
        if (!cacheUsages.isEmpty()) {
            this.clusterBus.post(LookupTablesUpdated.create(cacheUsages));
        }
        return CacheApi.fromDto(saved);
    }

    @JsonAutoDetect
    public static class CachesPage {
        @Nullable
        @JsonProperty
        private final String query;
        @JsonUnwrapped
        private final PaginatedList.PaginationInfo paginationInfo;
        @JsonProperty(value="caches")
        private final List<CacheApi> caches;

        public CachesPage(@Nullable String query, PaginatedList.PaginationInfo paginationInfo, List<CacheApi> caches) {
            this.query = query;
            this.paginationInfo = paginationInfo;
            this.caches = caches;
        }
    }

    @JsonAutoDetect
    public static class DataAdapterPage {
        @Nullable
        @JsonProperty
        private final String query;
        @JsonUnwrapped
        private final PaginatedList.PaginationInfo paginationInfo;
        @JsonProperty(value="data_adapters")
        private final List<DataAdapterApi> dataAdapters;

        public DataAdapterPage(@Nullable String query, PaginatedList.PaginationInfo paginationInfo, List<DataAdapterApi> dataAdapters) {
            this.query = query;
            this.paginationInfo = paginationInfo;
            this.dataAdapters = dataAdapters;
        }
    }

    @JsonAutoDetect
    public static class LookupTablePage {
        @Nullable
        @JsonProperty
        private final String query;
        @JsonUnwrapped
        private final PaginatedList.PaginationInfo paginationInfo;
        @JsonProperty(value="lookup_tables")
        private final List<LookupTableApi> lookupTables;
        @JsonProperty(value="caches")
        private final Map<String, CacheApi> cacheApiMap;
        @JsonProperty(value="data_adapters")
        private final Map<String, DataAdapterApi> dataAdapterMap;

        public LookupTablePage(@Nullable String query, PaginatedList.PaginationInfo paginationInfo, List<LookupTableApi> lookupTables, Collection<CacheApi> caches, Collection<DataAdapterApi> dataAdapters) {
            this.query = query;
            this.paginationInfo = paginationInfo;
            this.lookupTables = lookupTables;
            this.cacheApiMap = Maps.uniqueIndex(caches, CacheApi::id);
            this.dataAdapterMap = Maps.uniqueIndex(dataAdapters, DataAdapterApi::id);
        }
    }
}

