/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.tools;

import com.codahale.metrics.annotation.Timed;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.rest.models.tools.requests.ContainsStringTestRequest;
import org.graylog2.rest.models.tools.responses.ContainsStringTesterResponse;
import org.graylog2.shared.rest.resources.RestResource;
import org.hibernate.validator.constraints.NotEmpty;

@RequiresAuthentication
@Path(value="/tools/contains_string_tester")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class ContainsStringTesterResource
extends RestResource {
    @GET
    @Timed
    public ContainsStringTesterResponse containsStringTest(@QueryParam(value="string") @NotEmpty String string, @QueryParam(value="search_string") @NotEmpty String searchString) {
        return this.doTestContainsString(string, searchString);
    }

    @POST
    @Timed
    @NoAuditEvent(value="only used to test if field contains a string")
    public ContainsStringTesterResponse testContainsString(@Valid @NotNull ContainsStringTestRequest request) {
        return this.doTestContainsString(request.string(), request.searchString());
    }

    private ContainsStringTesterResponse doTestContainsString(String string, String searchString) {
        int index = string.indexOf(searchString);
        boolean contains = index != -1;
        ContainsStringTesterResponse.Match match = contains ? ContainsStringTesterResponse.Match.create(index, index + searchString.length()) : null;
        return ContainsStringTesterResponse.create(contains, match, searchString, string);
    }
}

