/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.users;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.bson.types.ObjectId;
import org.graylog2.Configuration;
import org.graylog2.database.CollectionName;
import org.graylog2.database.ObjectIdStringFunction;
import org.graylog2.database.PersistedImpl;
import org.graylog2.database.StringObjectIdFunction;
import org.graylog2.database.validators.FilledStringValidator;
import org.graylog2.database.validators.LimitedOptionalStringValidator;
import org.graylog2.database.validators.LimitedStringValidator;
import org.graylog2.database.validators.ListValidator;
import org.graylog2.plugin.database.users.User;
import org.graylog2.plugin.database.validators.Validator;
import org.graylog2.plugin.security.PasswordAlgorithm;
import org.graylog2.rest.models.users.requests.Startpage;
import org.graylog2.security.PasswordAlgorithmFactory;
import org.graylog2.shared.security.Permissions;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CollectionName(value="users")
public class UserImpl
extends PersistedImpl
implements User {
    private final PasswordAlgorithmFactory passwordAlgorithmFactory;
    private final Permissions permissions;
    private static final Logger LOG = LoggerFactory.getLogger(UserImpl.class);
    private static final Map<String, Object> DEFAULT_PREFERENCES = new ImmutableMap.Builder().put((Object)"updateUnfocussed", (Object)false).put((Object)"disableExpensiveUpdates", (Object)false).put((Object)"enableSmartSearch", (Object)true).build();
    public static final String COLLECTION_NAME = "users";
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    public static final String EMAIL = "email";
    public static final String FULL_NAME = "full_name";
    public static final String PERMISSIONS = "permissions";
    public static final String PREFERENCES = "preferences";
    public static final String TIMEZONE = "timezone";
    public static final String EXTERNAL_USER = "external_user";
    public static final String SESSION_TIMEOUT = "session_timeout_ms";
    public static final String STARTPAGE = "startpage";
    public static final String ROLES = "roles";
    public static final int MAX_USERNAME_LENGTH = 100;
    public static final int MAX_EMAIL_LENGTH = 254;
    public static final int MAX_FULL_NAME_LENGTH = 200;

    @AssistedInject
    public UserImpl(PasswordAlgorithmFactory passwordAlgorithmFactory, Permissions permissions, @Assisted Map<String, Object> fields) {
        super(fields);
        this.passwordAlgorithmFactory = passwordAlgorithmFactory;
        this.permissions = permissions;
    }

    @AssistedInject
    protected UserImpl(PasswordAlgorithmFactory passwordAlgorithmFactory, Permissions permissions, @Assisted ObjectId id, @Assisted Map<String, Object> fields) {
        super(id, fields);
        this.passwordAlgorithmFactory = passwordAlgorithmFactory;
        this.permissions = permissions;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public Map<String, Validator> getValidations() {
        return ImmutableMap.builder().put((Object)USERNAME, (Object)new LimitedStringValidator(1, 100)).put((Object)PASSWORD, (Object)new FilledStringValidator()).put((Object)EMAIL, (Object)new LimitedStringValidator(1, 254)).put((Object)FULL_NAME, (Object)new LimitedOptionalStringValidator(200)).put((Object)PERMISSIONS, (Object)new ListValidator()).put((Object)ROLES, (Object)new ListValidator(true)).build();
    }

    @Override
    public Map<String, Validator> getEmbeddedValidations(String key) {
        return Collections.emptyMap();
    }

    @Override
    public String getFullName() {
        return String.valueOf(this.fields.get(FULL_NAME));
    }

    @Override
    public void setFullName(String fullname) {
        this.fields.put(FULL_NAME, fullname);
    }

    @Override
    public String getName() {
        return String.valueOf(this.fields.get(USERNAME));
    }

    @Override
    public void setName(String username) {
        this.fields.put(USERNAME, username);
    }

    @Override
    public String getEmail() {
        return Strings.nullToEmpty((String)((String)this.fields.get(EMAIL)));
    }

    @Override
    public void setEmail(String email) {
        this.fields.put(EMAIL, email);
    }

    @Override
    public List<String> getPermissions() {
        HashSet<String> permissionSet = new HashSet<String>(this.permissions.userSelfEditPermissions(this.getName()));
        List permissions = (List)this.fields.get(PERMISSIONS);
        if (permissions != null) {
            permissionSet.addAll(permissions);
        }
        return new ArrayList<String>(permissionSet);
    }

    @Override
    public void setPermissions(List<String> permissions) {
        ArrayList perms = Lists.newArrayList(permissions);
        perms.removeAll(this.permissions.userSelfEditPermissions(this.getName()));
        this.fields.put(PERMISSIONS, perms);
    }

    @Override
    public Map<String, Object> getPreferences() {
        Map preferences = (Map)this.fields.get(PREFERENCES);
        return preferences == null || preferences.isEmpty() ? DEFAULT_PREFERENCES : preferences;
    }

    @Override
    public void setPreferences(Map<String, Object> preferences) {
        this.fields.put(PREFERENCES, preferences);
    }

    @Override
    public Startpage getStartpage() {
        if (this.fields.containsKey(STARTPAGE)) {
            Map obj = (Map)this.fields.get(STARTPAGE);
            String type = (String)obj.get("type");
            String id = (String)obj.get("id");
            if (type != null && id != null) {
                return Startpage.create(type, id);
            }
        }
        return null;
    }

    @Override
    public long getSessionTimeoutMs() {
        Object o = this.fields.get(SESSION_TIMEOUT);
        if (o != null && o instanceof Long) {
            return (Long)o;
        }
        return TimeUnit.HOURS.toMillis(8L);
    }

    @Override
    public void setSessionTimeoutMs(long timeoutValue) {
        this.fields.put(SESSION_TIMEOUT, timeoutValue);
    }

    @Override
    public String getHashedPassword() {
        return MoreObjects.firstNonNull(this.fields.get(PASSWORD), (Object)"").toString();
    }

    public void setHashedPassword(String hashedPassword) {
        this.fields.put(PASSWORD, hashedPassword);
    }

    @Override
    public void setPassword(String password) {
        if (password == null || "".equals(password)) {
            this.setHashedPassword("");
        } else {
            String newPassword = this.passwordAlgorithmFactory.defaultPasswordAlgorithm().hash(password);
            this.setHashedPassword(newPassword);
        }
    }

    @Override
    public boolean isUserPassword(String password) {
        PasswordAlgorithm passwordAlgorithm = this.passwordAlgorithmFactory.forPassword(this.getHashedPassword());
        if (passwordAlgorithm == null) {
            return false;
        }
        return passwordAlgorithm.matches(this.getHashedPassword(), password);
    }

    @Override
    public DateTimeZone getTimeZone() {
        Object o = this.fields.get(TIMEZONE);
        try {
            if (o != null) {
                return DateTimeZone.forID((String)o.toString());
            }
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Invalid timezone \"{}\" saved for user \"{}\"", o, (Object)this.getName());
        }
        return null;
    }

    @Override
    public void setTimeZone(String timeZone) {
        DateTimeZone dateTimeZone;
        try {
            dateTimeZone = DateTimeZone.forID((String)((String)MoreObjects.firstNonNull((Object)timeZone, (Object)DateTimeZone.UTC.getID())));
        }
        catch (IllegalArgumentException e) {
            LOG.info("Invalid timezone \"{}\", falling back to UTC.", (Object)timeZone);
            dateTimeZone = DateTimeZone.UTC;
        }
        this.setTimeZone(dateTimeZone);
    }

    @Override
    public void setTimeZone(DateTimeZone timeZone) {
        this.fields.put(TIMEZONE, timeZone.getID());
    }

    @Override
    public boolean isExternalUser() {
        return Boolean.valueOf(String.valueOf(this.fields.get(EXTERNAL_USER)));
    }

    @Override
    public void setExternal(boolean external) {
        this.fields.put(EXTERNAL_USER, external);
    }

    @Override
    public boolean isLocalAdmin() {
        return false;
    }

    @Override
    @Nonnull
    public Set<String> getRoleIds() {
        List roles = (List)MoreObjects.firstNonNull((Object)((List)this.fields.get(ROLES)), Collections.emptyList());
        return new HashSet<String>(Collections2.transform((Collection)roles, (Function)new ObjectIdStringFunction()));
    }

    @Override
    public void setRoleIds(Set<String> roles) {
        this.fields.put(ROLES, new ArrayList(Collections2.transform(roles, (Function)new StringObjectIdFunction())));
    }

    @Override
    public void setStartpage(String type, String id) {
        Startpage nextStartpage = type != null && id != null ? Startpage.create(type, id) : null;
        this.setStartpage(nextStartpage);
    }

    @Override
    public void setStartpage(Startpage startpage) {
        HashMap<String, String> startpageMap = new HashMap<String, String>();
        if (startpage != null) {
            startpageMap.put("type", startpage.type());
            startpageMap.put("id", startpage.id());
        }
        this.fields.put(STARTPAGE, startpageMap);
    }

    public static class LocalAdminUser
    extends UserImpl {
        private final Configuration configuration;
        private final Set<String> roles;

        @AssistedInject
        LocalAdminUser(PasswordAlgorithmFactory passwordAlgorithmFactory, Configuration configuration, @Assisted String adminRoleObjectId) {
            super(passwordAlgorithmFactory, null, null, Collections.emptyMap());
            this.configuration = configuration;
            this.roles = ImmutableSet.of((Object)adminRoleObjectId);
        }

        @Override
        public String getId() {
            return "local:admin";
        }

        @Override
        public String getFullName() {
            return "Administrator";
        }

        @Override
        public String getEmail() {
            return this.configuration.getRootEmail();
        }

        @Override
        public String getName() {
            return this.configuration.getRootUsername();
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        @Override
        public boolean isExternalUser() {
            return false;
        }

        @Override
        public List<String> getPermissions() {
            return Collections.singletonList("*");
        }

        @Override
        public Map<String, Object> getPreferences() {
            return DEFAULT_PREFERENCES;
        }

        @Override
        public long getSessionTimeoutMs() {
            return TimeUnit.HOURS.toMillis(8L);
        }

        @Override
        public DateTimeZone getTimeZone() {
            return this.configuration.getRootTimeZone();
        }

        @Override
        public boolean isLocalAdmin() {
            return true;
        }

        @Override
        @Nonnull
        public Set<String> getRoleIds() {
            return this.roles;
        }

        @Override
        public void setRoleIds(Set<String> roles) {
        }
    }

    public static interface Factory {
        public UserImpl create(Map<String, Object> var1);

        public UserImpl create(ObjectId var1, Map<String, Object> var2);

        public LocalAdminUser createLocalAdminUser(String var1);
    }
}

