/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.alerts;

import java.util.Optional;
import javax.inject.Inject;
import org.graylog2.alerts.Alert;
import org.graylog2.alerts.AlertNotificationsSender;
import org.graylog2.alerts.AlertService;
import org.graylog2.plugin.alarms.AlertCondition;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.plugin.streams.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlertScanner {
    private static final Logger LOG = LoggerFactory.getLogger(AlertScanner.class);
    private final AlertService alertService;
    private final AlertNotificationsSender alertNotificationsSender;

    @Inject
    public AlertScanner(AlertService alertService, AlertNotificationsSender alertNotificationsSender) {
        this.alertService = alertService;
        this.alertNotificationsSender = alertNotificationsSender;
    }

    private Alert handleTriggeredAlert(AlertCondition.CheckResult result, Stream stream, AlertCondition alertCondition) throws ValidationException {
        Alert alert = this.alertService.factory(result);
        this.alertService.save(alert);
        this.alertNotificationsSender.send(result, stream, alert, alertCondition);
        return alert;
    }

    private void handleRepeatedAlert(Stream stream, AlertCondition alertCondition, AlertCondition.CheckResult result, Alert alert2) {
        this.alertNotificationsSender.send(result, stream, alert2, alertCondition);
    }

    private void handleResolveAlert(Alert alert) {
        this.alertService.resolveAlert(alert);
    }

    public boolean checkAlertCondition(Stream stream, AlertCondition alertCondition) {
        if (stream.isPaused().booleanValue() || this.alertService.inGracePeriod(alertCondition)) {
            return false;
        }
        try {
            AlertCondition.CheckResult result = alertCondition.runCheck();
            Optional<Alert> alert = this.alertService.getLastTriggeredAlert(stream.getId(), alertCondition.getId());
            if (result.isTriggered()) {
                if (!alert.isPresent() || this.alertService.isResolved(alert.get())) {
                    LOG.debug("Alert condition [{}] is triggered. Sending alerts.", (Object)alertCondition);
                    this.handleTriggeredAlert(result, stream, alertCondition);
                } else {
                    Alert triggeredAlert = alert.get();
                    if (this.alertService.shouldRepeatNotifications(alertCondition, triggeredAlert)) {
                        LOG.debug("Alert condition [{}] is triggered and configured to repeat alert notifications. Sending alerts.", (Object)alertCondition);
                        this.handleRepeatedAlert(stream, alertCondition, result, triggeredAlert);
                    } else {
                        LOG.debug("Alert condition [{}] is triggered but alerts were already sent. Nothing to do.", (Object)alertCondition);
                    }
                }
                return true;
            }
            if (alert.isPresent() && !this.alertService.isResolved(alert.get())) {
                LOG.debug("Alert condition [{}]\u00a0is not triggered anymore. Resolving alert.", (Object)alertCondition);
                this.handleResolveAlert(alert.get());
            } else {
                LOG.debug("Alert condition [{}]\u00a0is not triggered and is marked as resolved. Nothing to do.", (Object)alertCondition);
            }
        }
        catch (Exception e) {
            LOG.error("Skipping alert check that threw an exception.", (Throwable)e);
        }
        return false;
    }
}

