/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.bindings.providers;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.Authenticator;
import org.apache.shiro.authc.pam.AuthenticationStrategy;
import org.apache.shiro.authc.pam.FirstSuccessfulStrategy;
import org.apache.shiro.authc.pam.ModularRealmAuthenticator;
import org.apache.shiro.authz.Authorizer;
import org.apache.shiro.authz.ModularRealmAuthorizer;
import org.apache.shiro.authz.permission.RolePermissionResolver;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.cache.MemoryConstrainedCacheManager;
import org.apache.shiro.mgt.DefaultSecurityManager;
import org.apache.shiro.mgt.DefaultSessionStorageEvaluator;
import org.apache.shiro.mgt.DefaultSubjectDAO;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.mgt.SessionStorageEvaluator;
import org.apache.shiro.mgt.SubjectDAO;
import org.apache.shiro.session.mgt.DefaultSessionManager;
import org.apache.shiro.session.mgt.eis.SessionDAO;
import org.apache.shiro.subject.Subject;
import org.graylog2.security.InMemoryRolePermissionResolver;
import org.graylog2.security.MongoDbSessionDAO;
import org.graylog2.security.OrderedAuthenticatingRealms;
import org.graylog2.security.realm.MongoDbAuthorizationRealm;
import org.graylog2.security.realm.RootAccountRealm;

@Singleton
public class DefaultSecurityManagerProvider
implements Provider<DefaultSecurityManager> {
    private DefaultSecurityManager sm = null;

    @Inject
    public DefaultSecurityManagerProvider(MongoDbSessionDAO mongoDbSessionDAO, MongoDbAuthorizationRealm mongoDbAuthorizationRealm, RootAccountRealm rootAccountRealm, InMemoryRolePermissionResolver inMemoryRolePermissionResolver, OrderedAuthenticatingRealms orderedAuthenticatingRealms) {
        this.sm = new DefaultSecurityManager((Collection)orderedAuthenticatingRealms);
        Authenticator authenticator = this.sm.getAuthenticator();
        if (authenticator instanceof ModularRealmAuthenticator) {
            ((ModularRealmAuthenticator)authenticator).setAuthenticationStrategy((AuthenticationStrategy)new FirstSuccessfulStrategy());
        }
        ModularRealmAuthorizer authorizer = new ModularRealmAuthorizer((Collection)ImmutableList.of((Object)((Object)mongoDbAuthorizationRealm), (Object)((Object)rootAccountRealm)));
        authorizer.setRolePermissionResolver((RolePermissionResolver)inMemoryRolePermissionResolver);
        this.sm.setAuthorizer((Authorizer)authorizer);
        DefaultSubjectDAO subjectDAO = new DefaultSubjectDAO();
        DefaultSessionStorageEvaluator sessionStorageEvaluator = new DefaultSessionStorageEvaluator(){

            public boolean isSessionStorageEnabled(Subject subject) {
                return subject.getSession(false) != null;
            }
        };
        sessionStorageEvaluator.setSessionStorageEnabled(false);
        subjectDAO.setSessionStorageEvaluator((SessionStorageEvaluator)sessionStorageEvaluator);
        this.sm.setSubjectDAO((SubjectDAO)subjectDAO);
        DefaultSessionManager defaultSessionManager = (DefaultSessionManager)this.sm.getSessionManager();
        defaultSessionManager.setSessionDAO((SessionDAO)mongoDbSessionDAO);
        defaultSessionManager.setDeleteInvalidSessions(true);
        defaultSessionManager.setSessionValidationInterval(TimeUnit.MINUTES.toMillis(5L));
        defaultSessionManager.setCacheManager((CacheManager)new MemoryConstrainedCacheManager());
        SecurityUtils.setSecurityManager((SecurityManager)this.sm);
    }

    public DefaultSecurityManager get() {
        return this.sm;
    }
}

