/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.bindings.providers;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.joschi.jadconfig.util.Duration;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestClientFactory;
import io.searchbox.client.config.HttpClientConfig;
import java.net.URI;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;

@Singleton
public class JestClientProvider
implements Provider<JestClient> {
    private final JestClientFactory factory = new JestClientFactory();
    private final CredentialsProvider credentialsProvider = new BasicCredentialsProvider();

    @Inject
    public JestClientProvider(@Named(value="elasticsearch_hosts") List<URI> elasticsearchHosts, @Named(value="elasticsearch_connect_timeout") Duration elasticsearchConnectTimeout, @Named(value="elasticsearch_socket_timeout") Duration elasticsearchSocketTimeout, @Named(value="elasticsearch_idle_timeout") Duration elasticsearchIdleTimeout, @Named(value="elasticsearch_max_total_connections") int elasticsearchMaxTotalConnections, @Named(value="elasticsearch_max_total_connections_per_route") int elasticsearchMaxTotalConnectionsPerRoute, @Named(value="elasticsearch_discovery_enabled") boolean discoveryEnabled, @Named(value="elasticsearch_discovery_filter") @Nullable String discoveryFilter, @Named(value="elasticsearch_discovery_frequency") Duration discoveryFrequency, @Named(value="elasticsearch_compression_enabled") boolean compressionEnabled, ObjectMapper objectMapper) {
        HashSet preemptiveAuthHosts = new HashSet();
        List hosts = elasticsearchHosts.stream().map(hostUri -> {
            Iterator splittedUserInfo;
            if (!Strings.isNullOrEmpty((String)hostUri.getUserInfo()) && (splittedUserInfo = Splitter.on((String)":").split((CharSequence)hostUri.getUserInfo()).iterator()).hasNext()) {
                String username = (String)splittedUserInfo.next();
                String password = splittedUserInfo.hasNext() ? (String)splittedUserInfo.next() : null;
                this.credentialsProvider.setCredentials(new AuthScope(hostUri.getHost(), hostUri.getPort(), AuthScope.ANY_REALM, hostUri.getScheme()), (Credentials)new UsernamePasswordCredentials(username, password));
                if (!Strings.isNullOrEmpty((String)username) || !Strings.isNullOrEmpty((String)password)) {
                    preemptiveAuthHosts.add(new HttpHost(hostUri.getHost(), hostUri.getPort(), hostUri.getScheme()));
                }
            }
            return hostUri.toString();
        }).collect(Collectors.toList());
        HttpClientConfig.Builder httpClientConfigBuilder = (HttpClientConfig.Builder)((HttpClientConfig.Builder)((HttpClientConfig.Builder)((HttpClientConfig.Builder)((HttpClientConfig.Builder)((HttpClientConfig.Builder)((HttpClientConfig.Builder)((HttpClientConfig.Builder)((HttpClientConfig.Builder)new HttpClientConfig.Builder(hosts).credentialsProvider(this.credentialsProvider).connTimeout(Math.toIntExact(elasticsearchConnectTimeout.toMilliseconds()))).readTimeout(Math.toIntExact(elasticsearchSocketTimeout.toMilliseconds()))).maxConnectionIdleTime(elasticsearchIdleTimeout.toSeconds(), TimeUnit.SECONDS)).maxTotalConnection(elasticsearchMaxTotalConnections).defaultMaxTotalConnectionPerRoute(elasticsearchMaxTotalConnectionsPerRoute).multiThreaded(true)).discoveryEnabled(discoveryEnabled)).discoveryFilter(discoveryFilter)).discoveryFrequency(discoveryFrequency.toSeconds(), TimeUnit.SECONDS)).preemptiveAuthTargetHosts(preemptiveAuthHosts).requestCompressionEnabled(compressionEnabled)).objectMapper(objectMapper);
        this.factory.setHttpClientConfig(httpClientConfigBuilder.build());
    }

    public JestClient get() {
        return this.factory.getObject();
    }
}

