/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.bindings.providers;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.graylog2.plugin.RulesEngine;
import org.graylog2.rules.DroolsEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class RulesEngineProvider
implements Provider<RulesEngine> {
    private static final Logger LOG = LoggerFactory.getLogger(RulesEngineProvider.class);
    private final RulesEngine rulesEngine;

    @Inject
    public RulesEngineProvider(DroolsEngine droolsEngine, @Named(value="rules_file") @Nullable String rulesFilePath) {
        this.rulesEngine = (RulesEngine)Preconditions.checkNotNull((Object)droolsEngine);
        if (!Strings.isNullOrEmpty((String)rulesFilePath)) {
            if (this.rulesEngine.addRulesFromFile(rulesFilePath)) {
                LOG.info("Using rules: {}", (Object)rulesFilePath);
            } else {
                LOG.warn("Unable to load rules due to load error: {}", (Object)rulesFilePath);
            }
        } else {
            LOG.info("No static rules file loaded.");
        }
    }

    public RulesEngine get() {
        return this.rulesEngine;
    }
}

