/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.commands.journal;

import com.github.rvesse.airline.annotations.Command;
import com.github.rvesse.airline.annotations.Option;
import kafka.log.LogSegment;
import org.graylog2.commands.journal.AbstractJournalCommand;
import org.graylog2.shared.journal.KafkaJournal;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

@Command(name="show", description="Shows information about the persisted message journal")
public class JournalShow
extends AbstractJournalCommand {
    @Option(name={"-s", "--show-segments"}, description="Show detail information for all segments")
    private boolean showSegmentDetails = false;

    public JournalShow() {
        super("show-journal");
    }

    @Override
    protected void runCommand() {
        long sizeInBytes = this.journal.size();
        int numSegments = this.journal.numberOfSegments();
        long committedReadOffset = this.journal.getCommittedReadOffset();
        StringBuffer sb = new StringBuffer();
        long startOffset = this.journal.getLogStartOffset();
        long lastOffset = this.journal.getLogEndOffset() - 1L;
        sb.append("Graylog message journal in directory: ").append(this.kafkaJournalConfiguration.getMessageJournalDir().getAbsolutePath()).append("\n");
        sb.append("\t").append("Total size in bytes: ").append(sizeInBytes).append("\n");
        sb.append("\t").append("Number of segments: ").append(numSegments).append("\n");
        sb.append("\t").append("Log start offset: ").append(startOffset).append("\n");
        sb.append("\t").append("Log end offset: ").append(lastOffset).append("\n");
        sb.append("\t").append("Number of messages: ").append(lastOffset - startOffset + 1L).append("\n");
        sb.append("\t").append("Committed read offset: ");
        if (committedReadOffset == Long.MIN_VALUE) {
            sb.append("nothing committed");
        } else {
            sb.append(committedReadOffset);
        }
        sb.append("\n");
        if (this.showSegmentDetails) {
            this.appendSegmentDetails(this.journal, sb);
        }
        sb.append("\n");
        System.out.print(sb);
        System.out.flush();
    }

    private void appendSegmentDetails(KafkaJournal journal, StringBuffer sb) {
        Iterable<LogSegment> segments = journal.getSegments();
        int i = 1;
        for (LogSegment segment : segments) {
            sb.append("\t\t").append("Segment ").append(i++).append("\n");
            sb.append("\t\t\t").append("Base offset: ").append(segment.baseOffset()).append("\n");
            sb.append("\t\t\t").append("Size in bytes: ").append(segment.size()).append("\n");
            sb.append("\t\t\t").append("Created at: ").append(new DateTime(segment.created(), DateTimeZone.UTC)).append("\n");
            sb.append("\t\t\t").append("Last modified: ").append(new DateTime(segment.lastModified(), DateTimeZone.UTC)).append("\n");
        }
    }
}

