/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.dashboards.widgets.strategies;

import com.google.common.base.Strings;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.util.Map;
import org.graylog2.dashboards.widgets.strategies.SearchResultCountWidgetStrategy;
import org.graylog2.indexer.searches.Searches;
import org.graylog2.plugin.dashboards.widgets.ComputationResult;
import org.graylog2.plugin.dashboards.widgets.WidgetStrategy;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;

public class StreamSearchResultCountWidgetStrategy
extends SearchResultCountWidgetStrategy {
    private final String streamId;

    @AssistedInject
    public StreamSearchResultCountWidgetStrategy(Searches searches, @Assisted Map<String, Object> config, @Assisted TimeRange timeRange, @Assisted String widgetId) {
        super(searches, config, timeRange, widgetId);
        this.streamId = (String)config.get("stream_id");
    }

    @Override
    public ComputationResult compute() {
        String filter = null;
        if (!Strings.isNullOrEmpty((String)this.streamId)) {
            filter = "streams:" + this.streamId;
        }
        return this.computeInternal(filter);
    }

    public static interface Factory
    extends WidgetStrategy.Factory<StreamSearchResultCountWidgetStrategy> {
        @Override
        public StreamSearchResultCountWidgetStrategy create(Map<String, Object> var1, TimeRange var2, String var3);
    }
}

