/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.database.validators;

import com.google.common.base.Preconditions;
import org.graylog2.database.validators.FilledStringValidator;
import org.graylog2.plugin.database.validators.ValidationResult;

public class LimitedStringValidator
extends FilledStringValidator {
    private final int minLength;
    private final int maxLength;

    public LimitedStringValidator(int minLength, int maxLength) {
        Preconditions.checkArgument((minLength > 0 ? 1 : 0) != 0, (Object)"minLength must be greater than 0");
        Preconditions.checkArgument((maxLength > 0 ? 1 : 0) != 0, (Object)"maxLength must be greater than 0");
        Preconditions.checkArgument((minLength <= maxLength ? 1 : 0) != 0, (Object)"maxLength must be greater than or equal to minLength");
        this.minLength = minLength;
        this.maxLength = maxLength;
    }

    @Override
    public ValidationResult validate(Object value) {
        String sValue;
        ValidationResult result = super.validate(value);
        if (result instanceof ValidationResult.ValidationPassed && ((sValue = (String)value).length() < this.minLength || sValue.length() > this.maxLength)) {
            result = new ValidationResult.ValidationFailed("Value is not between " + this.minLength + " and " + this.maxLength + " in length!");
        }
        return result;
    }
}

