/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.results;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.searchbox.core.search.aggregation.CardinalityAggregation;
import io.searchbox.core.search.aggregation.HistogramAggregation;
import io.searchbox.core.search.aggregation.StatsAggregation;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.graylog2.indexer.results.HistogramResult;
import org.graylog2.indexer.searches.Searches;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.MutableDateTime;
import org.joda.time.ReadablePeriod;

public class FieldHistogramResult
extends HistogramResult {
    private static final Map<String, Number> EMPTY_RESULT = ImmutableMap.builder().put((Object)"count", (Object)0).put((Object)"min", (Object)0).put((Object)"max", (Object)0).put((Object)"total", (Object)0).put((Object)"total_count", (Object)0).put((Object)"mean", (Object)0).build();
    private final Map<Long, Map<String, Number>> result;
    private final Searches.DateHistogramInterval interval;

    public FieldHistogramResult(HistogramAggregation histogramAggregation, String originalQuery, String builtQuery, Searches.DateHistogramInterval interval, long tookMs) {
        super(originalQuery, builtQuery, tookMs);
        this.interval = interval;
        this.result = this.getResultsFromHistogramAggregation(histogramAggregation);
    }

    @Override
    public Searches.DateHistogramInterval getInterval() {
        return this.interval;
    }

    @Override
    public Map getResults() {
        return this.result;
    }

    private Map<Long, Map<String, Number>> getResultsFromHistogramAggregation(HistogramAggregation histogramAggregation) {
        if (histogramAggregation.getBuckets().isEmpty()) {
            return Collections.emptyMap();
        }
        TreeMap results = Maps.newTreeMap();
        for (HistogramAggregation.Histogram b : histogramAggregation.getBuckets()) {
            ImmutableMap.Builder resultMap = ImmutableMap.builder();
            resultMap.put((Object)"total_count", (Object)b.getCount());
            StatsAggregation stats = b.getStatsAggregation("gl2_stats");
            resultMap.put((Object)"count", (Object)stats.getCount());
            resultMap.put((Object)"min", (Object)(stats.getMin() == null ? 0.0 : stats.getMin()));
            resultMap.put((Object)"max", (Object)(stats.getMax() == null ? 0.0 : stats.getMax()));
            resultMap.put((Object)"total", (Object)(stats.getSum() == null ? 0.0 : stats.getSum()));
            resultMap.put((Object)"mean", (Object)(stats.getAvg() == null ? 0.0 : stats.getAvg()));
            CardinalityAggregation cardinality = b.getCardinalityAggregation("gl2_field_cardinality");
            resultMap.put((Object)"cardinality", (Object)(cardinality == null ? 0L : cardinality.getCardinality()));
            DateTime keyAsDate = new DateTime((Object)b.getKey());
            long timestamp = keyAsDate.getMillis() / 1000L;
            results.put(timestamp, resultMap.build());
        }
        this.fillEmptyTimestamps(results);
        return results;
    }

    private void fillEmptyTimestamps(Map<Long, Map<String, Number>> results) {
        long minTimestamp = Collections.min(results.keySet());
        long maxTimestamp = Collections.max(results.keySet());
        MutableDateTime currentTime = new MutableDateTime(minTimestamp, DateTimeZone.UTC);
        while (currentTime.getMillis() < maxTimestamp) {
            Map<String, Number> entry = results.get(currentTime.getMillis());
            currentTime.add((ReadablePeriod)this.interval.getPeriod());
            if (entry != null) continue;
            results.put(currentTime.getMillis(), EMPTY_RESULT);
        }
    }

    private FieldHistogramResult(String originalQuery, String builtQuery, Searches.DateHistogramInterval interval) {
        super(originalQuery, builtQuery, 0L);
        this.result = Collections.emptyMap();
        this.interval = interval;
    }

    public static HistogramResult empty(String originalQuery, String builtQuery, Searches.DateHistogramInterval interval) {
        return new FieldHistogramResult(originalQuery, builtQuery, interval);
    }
}

