/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.results;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Range;
import java.util.HashMap;
import java.util.Map;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.Tools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultMessage {
    private static final Logger LOG = LoggerFactory.getLogger(ResultMessage.class);
    private Message message;
    private String index;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Multimap<String, Range<Integer>> highlightRanges;

    protected ResultMessage() {
    }

    public static ResultMessage parseFromSource(String id, String index, Map<String, Object> message) {
        ResultMessage m = new ResultMessage();
        m.setMessage(id, message);
        m.setIndex(index);
        return m;
    }

    public static ResultMessage createFromMessage(Message message) {
        ResultMessage m = new ResultMessage();
        m.setMessage(message);
        return m;
    }

    public void setMessage(Message message) {
        this.message = message;
    }

    public void setMessage(String id, Map<String, Object> message) {
        HashMap tmp = Maps.newHashMap();
        tmp.putAll(message);
        tmp.put("_id", id);
        if (tmp.containsKey("timestamp")) {
            Object tsField = tmp.get("timestamp");
            try {
                tmp.put("timestamp", Tools.ES_DATE_FORMAT_FORMATTER.parseDateTime(String.valueOf(tsField)));
            }
            catch (IllegalArgumentException e) {
                LOG.warn("Could not parse timestamp of message {}", message.get("id"), (Object)e);
            }
        }
        this.message = new Message(tmp);
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public Message getMessage() {
        return this.message;
    }

    public String getIndex() {
        return this.index;
    }
}

