/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest;

import com.google.common.base.Strings;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.security.Principal;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.SecurityContext;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.jersey.server.model.Resource;
import org.graylog2.shared.security.ShiroPrincipal;
import org.graylog2.shared.security.ShiroSecurityContext;
import org.jboss.netty.handler.ipfilter.IpSubnet;

public class RestTools {
    @Nullable
    public static String getUserNameFromRequest(ContainerRequestContext requestContext) {
        SecurityContext securityContext = requestContext.getSecurityContext();
        if (!(securityContext instanceof ShiroSecurityContext)) {
            return null;
        }
        ShiroSecurityContext shiroSecurityContext = (ShiroSecurityContext)securityContext;
        Principal userPrincipal = shiroSecurityContext.getUserPrincipal();
        if (!(userPrincipal instanceof ShiroPrincipal)) {
            return null;
        }
        ShiroPrincipal shiroPrincipal = (ShiroPrincipal)userPrincipal;
        return shiroPrincipal.getName();
    }

    public static String getRemoteAddrFromRequest(Request request, Set<IpSubnet> trustedSubnets) {
        String remoteAddr = request.getRemoteAddr();
        String XForwardedFor = request.getHeader("X-Forwarded-For");
        if (XForwardedFor != null) {
            for (IpSubnet s : trustedSubnets) {
                try {
                    if (!s.contains(remoteAddr)) continue;
                    return XForwardedFor;
                }
                catch (UnknownHostException unknownHostException) {
                }
            }
        }
        return remoteAddr;
    }

    public static String buildEndpointUri(@NotNull HttpHeaders httpHeaders, @NotNull URI defaultEndpointUri) {
        Optional<String> endpointUri = Optional.empty();
        List headers = httpHeaders.getRequestHeader("X-Graylog-Server-URL");
        if (headers != null && !headers.isEmpty()) {
            endpointUri = headers.stream().filter(s -> {
                try {
                    if (Strings.isNullOrEmpty((String)s)) {
                        return false;
                    }
                    URI uri = new URI((String)s);
                    if (!uri.isAbsolute()) {
                        return true;
                    }
                    switch (uri.getScheme()) {
                        case "http": 
                        case "https": {
                            return true;
                        }
                    }
                    return false;
                }
                catch (URISyntaxException e) {
                    return false;
                }
            }).findFirst();
        }
        return endpointUri.orElse(defaultEndpointUri.toString());
    }

    public static String getPathFromResource(Resource resource) {
        String path = resource.getPath();
        for (Resource parent = resource.getParent(); parent != null; parent = parent.getParent()) {
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            path = parent.getPath() + path;
        }
        return path;
    }
}

