/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system.bundles;

import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.net.URI;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.bundles.BundleService;
import org.graylog2.bundles.ConfigurationBundle;
import org.graylog2.bundles.ExportBundle;
import org.graylog2.database.NotFoundException;
import org.graylog2.shared.rest.resources.RestResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresAuthentication
@Api(value="System/Bundles", description="Content packs")
@Path(value="/system/bundles")
@Produces(value={"application/json"})
public class BundleResource
extends RestResource {
    private static final Logger LOG = LoggerFactory.getLogger(BundleResource.class);
    private final BundleService bundleService;

    @Inject
    public BundleResource(BundleService bundleService) {
        this.bundleService = bundleService;
    }

    @POST
    @Timed
    @Consumes(value={"application/json"})
    @ApiOperation(value="Upload a content pack")
    @ApiResponses(value={@ApiResponse(code=400, message="Missing or invalid content pack"), @ApiResponse(code=500, message="Error while saving content pack")})
    @AuditEvent(type="server:content_pack:create")
    public Response createBundle(@ApiParam(name="Request body", value="Content pack", required=true) @NotNull @Valid ConfigurationBundle configurationBundle) {
        this.checkPermission("bundle:create");
        ConfigurationBundle bundle = this.bundleService.insert(configurationBundle);
        URI bundleUri = this.getUriBuilderToSelf().path(BundleResource.class).path("{bundleId}").build(new Object[]{bundle.getId()});
        return Response.created((URI)bundleUri).build();
    }

    @GET
    @Timed
    @ApiOperation(value="List available content packs")
    @ApiResponses(value={@ApiResponse(code=500, message="Error loading content packs")})
    public Multimap<String, ConfigurationBundle> listBundles() {
        ImmutableSetMultimap.Builder categoryBundleMap = ImmutableSetMultimap.builder();
        for (ConfigurationBundle bundle : this.bundleService.loadAll()) {
            this.checkPermission("bundle:read", bundle.getId());
            categoryBundleMap.put((Object)bundle.getCategory(), (Object)bundle);
        }
        return categoryBundleMap.build();
    }

    @GET
    @Timed
    @Path(value="{bundleId}")
    @ApiOperation(value="Show content pack")
    @ApiResponses(value={@ApiResponse(code=404, message="Missing or invalid content pack"), @ApiResponse(code=500, message="Error while loading content pack")})
    public ConfigurationBundle showBundle(@ApiParam(name="bundleId", value="Content pack ID", required=true) @NotNull @PathParam(value="bundleId") String bundleId) throws NotFoundException {
        this.checkPermission("bundle:read", bundleId);
        return this.bundleService.load(bundleId);
    }

    @PUT
    @Timed
    @Path(value="{bundleId}")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Update content pack")
    @ApiResponses(value={@ApiResponse(code=400, message="Missing or invalid content pack"), @ApiResponse(code=500, message="Error while updating content pack")})
    @AuditEvent(type="server:content_pack:update")
    public void updateBundle(@ApiParam(name="bundleId", value="Content pack ID", required=true) @NotNull @PathParam(value="bundleId") String bundleId, @ApiParam(name="Request body", value="Content pack", required=true) @NotNull @Valid ConfigurationBundle configurationBundle) {
        this.checkPermission("bundle:update", bundleId);
        boolean result = this.bundleService.update(bundleId, configurationBundle);
        if (!result) {
            throw new InternalServerErrorException("Couldn't update content pack \"" + bundleId + "\"");
        }
    }

    @DELETE
    @Path(value="{bundleId}")
    @Timed
    @ApiOperation(value="Delete content pack")
    @ApiResponses(value={@ApiResponse(code=404, message="Missing or invalid content pack"), @ApiResponse(code=500, message="Error while applying content pack")})
    @AuditEvent(type="server:content_pack:delete")
    public void deleteBundle(@ApiParam(name="bundleId", value="Content pack ID", required=true) @NotNull @PathParam(value="bundleId") String bundleId) {
        this.checkPermission("bundle:delete", bundleId);
        int deletedBundles = this.bundleService.delete(bundleId);
        LOG.debug("Successfully removed {} content packs", (Object)deletedBundles);
    }

    @POST
    @Path(value="{bundleId}/apply")
    @Timed
    @ApiOperation(value="Set up entities described by content pack")
    @ApiResponses(value={@ApiResponse(code=404, message="Missing or invalid content pack"), @ApiResponse(code=500, message="Error while applying content pack")})
    @AuditEvent(type="server:content_pack:apply")
    public void applyBundle(@ApiParam(name="bundleId", value="Content pack ID", required=true) @NotNull @PathParam(value="bundleId") String bundleId) throws NotFoundException {
        this.checkPermission("bundle:import");
        this.bundleService.applyConfigurationBundle(bundleId, this.getCurrentUser());
    }

    @POST
    @Path(value="export")
    @Timed
    @ApiOperation(value="Export entities as a content pack")
    @ApiResponses(value={@ApiResponse(code=500, message="Error while exporting content pack")})
    @AuditEvent(type="server:content_pack:export")
    public ConfigurationBundle exportBundle(@ApiParam(name="exportBundle", value="Export content pack", required=true) @NotNull ExportBundle exportBundle) throws NotFoundException {
        this.checkPermission("bundle:export");
        return this.bundleService.exportConfigurationBundle(exportBundle);
    }
}

