/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system.indexer.responses;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.ZonedDateTime;
import javax.annotation.Nullable;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.graylog2.plugin.indexer.retention.RetentionStrategyConfig;
import org.graylog2.plugin.indexer.rotation.RotationStrategyConfig;
import org.graylog2.rest.resources.system.indexer.responses.IndexSetSummary;
import org.hibernate.validator.constraints.NotBlank;

abstract class $AutoValue_IndexSetSummary
extends IndexSetSummary {
    private final String id;
    private final String title;
    private final String description;
    private final boolean isDefault;
    private final boolean isWritable;
    private final String indexPrefix;
    private final int shards;
    private final int replicas;
    private final String rotationStrategyClass;
    private final RotationStrategyConfig rotationStrategy;
    private final String retentionStrategyClass;
    private final RetentionStrategyConfig retentionStrategy;
    private final ZonedDateTime creationDate;
    private final String indexAnalyzer;
    private final int indexOptimizationMaxNumSegments;
    private final boolean indexOptimizationDisabled;

    $AutoValue_IndexSetSummary(@Nullable String id, String title, @Nullable String description, boolean isDefault, boolean isWritable, String indexPrefix, int shards, int replicas, String rotationStrategyClass, RotationStrategyConfig rotationStrategy, String retentionStrategyClass, RetentionStrategyConfig retentionStrategy, ZonedDateTime creationDate, String indexAnalyzer, int indexOptimizationMaxNumSegments, boolean indexOptimizationDisabled) {
        this.id = id;
        if (title == null) {
            throw new NullPointerException("Null title");
        }
        this.title = title;
        this.description = description;
        this.isDefault = isDefault;
        this.isWritable = isWritable;
        if (indexPrefix == null) {
            throw new NullPointerException("Null indexPrefix");
        }
        this.indexPrefix = indexPrefix;
        this.shards = shards;
        this.replicas = replicas;
        if (rotationStrategyClass == null) {
            throw new NullPointerException("Null rotationStrategyClass");
        }
        this.rotationStrategyClass = rotationStrategyClass;
        if (rotationStrategy == null) {
            throw new NullPointerException("Null rotationStrategy");
        }
        this.rotationStrategy = rotationStrategy;
        if (retentionStrategyClass == null) {
            throw new NullPointerException("Null retentionStrategyClass");
        }
        this.retentionStrategyClass = retentionStrategyClass;
        if (retentionStrategy == null) {
            throw new NullPointerException("Null retentionStrategy");
        }
        this.retentionStrategy = retentionStrategy;
        if (creationDate == null) {
            throw new NullPointerException("Null creationDate");
        }
        this.creationDate = creationDate;
        if (indexAnalyzer == null) {
            throw new NullPointerException("Null indexAnalyzer");
        }
        this.indexAnalyzer = indexAnalyzer;
        this.indexOptimizationMaxNumSegments = indexOptimizationMaxNumSegments;
        this.indexOptimizationDisabled = indexOptimizationDisabled;
    }

    @Override
    @JsonProperty(value="id")
    @Nullable
    public String id() {
        return this.id;
    }

    @Override
    @JsonProperty(value="title")
    @NotBlank
    public String title() {
        return this.title;
    }

    @Override
    @JsonProperty(value="description")
    @Nullable
    public String description() {
        return this.description;
    }

    @Override
    @JsonProperty(value="default")
    public boolean isDefault() {
        return this.isDefault;
    }

    @Override
    @JsonProperty(value="writable")
    public boolean isWritable() {
        return this.isWritable;
    }

    @Override
    @JsonProperty(value="index_prefix")
    @Pattern(regexp="^[a-z0-9][a-z0-9_+-]*$")
    public String indexPrefix() {
        return this.indexPrefix;
    }

    @Override
    @JsonProperty(value="shards")
    @Min(value=1L)
    public int shards() {
        return this.shards;
    }

    @Override
    @JsonProperty(value="replicas")
    @Min(value=0L)
    public int replicas() {
        return this.replicas;
    }

    @Override
    @JsonProperty(value="rotation_strategy_class")
    @NotNull
    public String rotationStrategyClass() {
        return this.rotationStrategyClass;
    }

    @Override
    @JsonProperty(value="rotation_strategy")
    @NotNull
    public RotationStrategyConfig rotationStrategy() {
        return this.rotationStrategy;
    }

    @Override
    @JsonProperty(value="retention_strategy_class")
    @NotNull
    public String retentionStrategyClass() {
        return this.retentionStrategyClass;
    }

    @Override
    @JsonProperty(value="retention_strategy")
    @NotNull
    public RetentionStrategyConfig retentionStrategy() {
        return this.retentionStrategy;
    }

    @Override
    @JsonProperty(value="creation_date")
    @NotNull
    public ZonedDateTime creationDate() {
        return this.creationDate;
    }

    @Override
    @JsonProperty(value="index_analyzer")
    @NotBlank
    public String indexAnalyzer() {
        return this.indexAnalyzer;
    }

    @Override
    @JsonProperty(value="index_optimization_max_num_segments")
    @Min(value=1L)
    public int indexOptimizationMaxNumSegments() {
        return this.indexOptimizationMaxNumSegments;
    }

    @Override
    @JsonProperty(value="index_optimization_disabled")
    public boolean indexOptimizationDisabled() {
        return this.indexOptimizationDisabled;
    }

    public String toString() {
        return "IndexSetSummary{id=" + this.id + ", title=" + this.title + ", description=" + this.description + ", isDefault=" + this.isDefault + ", isWritable=" + this.isWritable + ", indexPrefix=" + this.indexPrefix + ", shards=" + this.shards + ", replicas=" + this.replicas + ", rotationStrategyClass=" + this.rotationStrategyClass + ", rotationStrategy=" + this.rotationStrategy + ", retentionStrategyClass=" + this.retentionStrategyClass + ", retentionStrategy=" + this.retentionStrategy + ", creationDate=" + this.creationDate + ", indexAnalyzer=" + this.indexAnalyzer + ", indexOptimizationMaxNumSegments=" + this.indexOptimizationMaxNumSegments + ", indexOptimizationDisabled=" + this.indexOptimizationDisabled + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof IndexSetSummary) {
            IndexSetSummary that = (IndexSetSummary)o;
            return (this.id == null ? that.id() == null : this.id.equals(that.id())) && this.title.equals(that.title()) && (this.description == null ? that.description() == null : this.description.equals(that.description())) && this.isDefault == that.isDefault() && this.isWritable == that.isWritable() && this.indexPrefix.equals(that.indexPrefix()) && this.shards == that.shards() && this.replicas == that.replicas() && this.rotationStrategyClass.equals(that.rotationStrategyClass()) && this.rotationStrategy.equals(that.rotationStrategy()) && this.retentionStrategyClass.equals(that.retentionStrategyClass()) && this.retentionStrategy.equals(that.retentionStrategy()) && this.creationDate.equals(that.creationDate()) && this.indexAnalyzer.equals(that.indexAnalyzer()) && this.indexOptimizationMaxNumSegments == that.indexOptimizationMaxNumSegments() && this.indexOptimizationDisabled == that.indexOptimizationDisabled();
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.id == null ? 0 : this.id.hashCode();
        h *= 1000003;
        h ^= this.title.hashCode();
        h *= 1000003;
        h ^= this.description == null ? 0 : this.description.hashCode();
        h *= 1000003;
        h ^= this.isDefault ? 1231 : 1237;
        h *= 1000003;
        h ^= this.isWritable ? 1231 : 1237;
        h *= 1000003;
        h ^= this.indexPrefix.hashCode();
        h *= 1000003;
        h ^= this.shards;
        h *= 1000003;
        h ^= this.replicas;
        h *= 1000003;
        h ^= this.rotationStrategyClass.hashCode();
        h *= 1000003;
        h ^= this.rotationStrategy.hashCode();
        h *= 1000003;
        h ^= this.retentionStrategyClass.hashCode();
        h *= 1000003;
        h ^= this.retentionStrategy.hashCode();
        h *= 1000003;
        h ^= this.creationDate.hashCode();
        h *= 1000003;
        h ^= this.indexAnalyzer.hashCode();
        h *= 1000003;
        h ^= this.indexOptimizationMaxNumSegments;
        h *= 1000003;
        return h ^= this.indexOptimizationDisabled ? 1231 : 1237;
    }
}

