/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.security;

import com.google.common.annotations.VisibleForTesting;
import java.security.Principal;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.SecurityContext;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.util.ThreadContext;
import org.graylog2.shared.security.ShiroPrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShiroSecurityContext
implements SecurityContext {
    public static final String AUTO_CREATE_SESSION_KEY = "AUTO_CREATE_SESSION";
    private static final Logger LOG = LoggerFactory.getLogger(ShiroSecurityContext.class);
    private Subject subject;
    private final AuthenticationToken token;
    private final boolean secure;
    private final String authcScheme;
    private final MultivaluedMap<String, String> headers;

    public ShiroSecurityContext(Subject subject, AuthenticationToken token, boolean isSecure, String authcScheme, MultivaluedMap<String, String> headers) {
        this.subject = subject;
        this.token = token;
        this.secure = isSecure;
        this.authcScheme = authcScheme;
        this.headers = new MultivaluedHashMap(headers);
    }

    public String getUsername() {
        if (this.token == null || this.token.getPrincipal() == null) {
            return null;
        }
        return this.token.getPrincipal().toString();
    }

    public String getPassword() {
        if (this.token == null || this.token.getCredentials() == null) {
            return null;
        }
        return this.token.getCredentials().toString();
    }

    public Subject getSubject() {
        return this.subject;
    }

    public Principal getUserPrincipal() {
        return new ShiroPrincipal(this.subject);
    }

    public boolean isUserInRole(String role) {
        LOG.debug("Checking role {} for user {}.", (Object)role, this.subject.getPrincipal());
        return this.subject.hasRole(role);
    }

    public boolean isSecure() {
        return this.secure;
    }

    public String getAuthenticationScheme() {
        return this.authcScheme;
    }

    @VisibleForTesting
    public AuthenticationToken getToken() {
        return this.token;
    }

    public MultivaluedMap<String, String> getHeaders() {
        return this.headers;
    }

    public void loginSubject() throws AuthenticationException {
        this.subject.login(this.token);
        Subject newSubject = ThreadContext.getSubject();
        if (newSubject != null) {
            this.subject = newSubject;
        }
    }

    public static boolean isSessionCreationRequested() {
        return Boolean.TRUE.equals(ThreadContext.get((Object)AUTO_CREATE_SESSION_KEY));
    }

    public static void requestSessionCreation(boolean createSessionRequest) {
        ThreadContext.put((Object)AUTO_CREATE_SESSION_KEY, (Object)createSessionRequest);
    }
}

