/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.searches;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import org.graylog2.indexer.searches.$AutoValue_SearchesClusterConfig;
import org.joda.time.Period;

@JsonAutoDetect
public abstract class SearchesClusterConfig {
    private static final Period DEFAULT_QUERY_TIME_RANGE_LIMIT = Period.ZERO;
    private static final Map<Period, String> DEFAULT_RELATIVE_TIMERANGE_OPTIONS = ImmutableMap.builder().put((Object)Period.minutes((int)5), (Object)"Search in the last 5 minutes").put((Object)Period.minutes((int)15), (Object)"Search in the last 15 minutes").put((Object)Period.minutes((int)30), (Object)"Search in the last 30 minutes").put((Object)Period.hours((int)1), (Object)"Search in the last 1 hour").put((Object)Period.hours((int)2), (Object)"Search in the last 2 hours").put((Object)Period.hours((int)8), (Object)"Search in the last 8 hours").put((Object)Period.days((int)1), (Object)"Search in the last 1 day").put((Object)Period.days((int)2), (Object)"Search in the last 2 days").put((Object)Period.days((int)5), (Object)"Search in the last 5 days").put((Object)Period.days((int)7), (Object)"Search in the last 7 days").put((Object)Period.days((int)14), (Object)"Search in the last 14 days").put((Object)Period.days((int)30), (Object)"Search in the last 30 days").put((Object)Period.ZERO, (Object)"Search in all messages").build();
    private static final Map<Period, String> DEFAULT_SURROUNDING_TIMERANGE_OPTIONS = ImmutableMap.builder().put((Object)Period.seconds((int)1), (Object)"1 second").put((Object)Period.seconds((int)5), (Object)"5 seconds").put((Object)Period.seconds((int)10), (Object)"10 seconds").put((Object)Period.seconds((int)30), (Object)"30 seconds").put((Object)Period.minutes((int)1), (Object)"1 minute").put((Object)Period.minutes((int)5), (Object)"5 minutes").build();
    private static final Set<String> DEFAULT_SURROUNDING_FILTER_FIELDS = ImmutableSet.builder().add((Object)"source").add((Object)"gl2_source_input").add((Object)"file").add((Object)"source_file").build();

    @JsonProperty(value="query_time_range_limit")
    public abstract Period queryTimeRangeLimit();

    @JsonProperty(value="relative_timerange_options")
    public abstract Map<Period, String> relativeTimerangeOptions();

    @JsonProperty(value="surrounding_timerange_options")
    public abstract Map<Period, String> surroundingTimerangeOptions();

    @JsonProperty(value="surrounding_filter_fields")
    public abstract Set<String> surroundingFilterFields();

    @JsonCreator
    public static SearchesClusterConfig create(@JsonProperty(value="query_time_range_limit") Period queryTimeRangeLimit, @JsonProperty(value="relative_timerange_options") Map<Period, String> relativeTimerangeOptions, @JsonProperty(value="surrounding_timerange_options") Map<Period, String> surroundingTimerangeOptions, @JsonProperty(value="surrounding_filter_fields") Set<String> surroundingFilterFields) {
        return SearchesClusterConfig.builder().queryTimeRangeLimit(queryTimeRangeLimit).relativeTimerangeOptions(relativeTimerangeOptions).surroundingTimerangeOptions(surroundingTimerangeOptions).surroundingFilterFields(surroundingFilterFields).build();
    }

    public static SearchesClusterConfig createDefault() {
        return SearchesClusterConfig.builder().queryTimeRangeLimit(DEFAULT_QUERY_TIME_RANGE_LIMIT).relativeTimerangeOptions(DEFAULT_RELATIVE_TIMERANGE_OPTIONS).surroundingTimerangeOptions(DEFAULT_SURROUNDING_TIMERANGE_OPTIONS).surroundingFilterFields(DEFAULT_SURROUNDING_FILTER_FIELDS).build();
    }

    public static Builder builder() {
        return new $AutoValue_SearchesClusterConfig.Builder();
    }

    public abstract Builder toBuilder();

    public static abstract class Builder {
        public abstract Builder queryTimeRangeLimit(Period var1);

        public abstract Builder relativeTimerangeOptions(Map<Period, String> var1);

        public abstract Builder surroundingTimerangeOptions(Map<Period, String> var1);

        public abstract Builder surroundingFilterFields(Set<String> var1);

        public abstract SearchesClusterConfig build();
    }
}

