/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.migrations;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Comparator;
import java.util.Objects;

public abstract class Migration
implements Comparable<Migration> {
    private static final Comparator<Migration> COMPARATOR = Comparator.comparingLong(migration -> migration.createdAt().toEpochSecond());

    public abstract ZonedDateTime createdAt();

    public abstract void upgrade();

    @Override
    public int compareTo(Migration that) {
        return COMPARATOR.compare(this, that);
    }

    public int hashCode() {
        return Objects.hash(COMPARATOR);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Migration that = (Migration)o;
        return Objects.equals(this.createdAt(), that.createdAt());
    }

    public String toString() {
        return this.getClass().getSimpleName() + '{' + this.createdAt().format(DateTimeFormatter.ISO_DATE_TIME) + '}';
    }
}

