/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system;

import com.google.common.collect.ImmutableMap;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.LockedAccountException;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.mgt.DefaultSecurityManager;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.UnknownSessionException;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.util.ThreadContext;
import org.glassfish.grizzly.http.server.Request;
import org.graylog2.audit.AuditActor;
import org.graylog2.audit.AuditEventSender;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.plugin.database.users.User;
import org.graylog2.rest.RestTools;
import org.graylog2.rest.models.system.sessions.requests.SessionCreateRequest;
import org.graylog2.rest.models.system.sessions.responses.SessionResponse;
import org.graylog2.rest.models.system.sessions.responses.SessionValidationResponse;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.shared.security.ShiroAuthenticationFilter;
import org.graylog2.shared.security.ShiroSecurityContext;
import org.graylog2.shared.users.UserService;
import org.graylog2.utilities.IpSubnet;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/system/sessions")
@Api(value="System/Sessions", description="Login for interactive user sessions")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class SessionsResource
extends RestResource {
    private static final Logger LOG = LoggerFactory.getLogger(SessionsResource.class);
    private final UserService userService;
    private final DefaultSecurityManager securityManager;
    private final ShiroAuthenticationFilter authenticationFilter;
    private final AuditEventSender auditEventSender;
    private final Set<IpSubnet> trustedSubnets;
    private final Request grizzlyRequest;

    @Inject
    public SessionsResource(UserService userService, DefaultSecurityManager securityManager, ShiroAuthenticationFilter authenticationFilter, AuditEventSender auditEventSender, @Named(value="trusted_proxies") Set<IpSubnet> trustedSubnets, @Context Request grizzlyRequest) {
        this.userService = userService;
        this.securityManager = securityManager;
        this.authenticationFilter = authenticationFilter;
        this.auditEventSender = auditEventSender;
        this.trustedSubnets = trustedSubnets;
        this.grizzlyRequest = grizzlyRequest;
    }

    @POST
    @ApiOperation(value="Create a new session", notes="This request creates a new session for a user or reactivates an existing session: the equivalent of logging in.")
    @NoAuditEvent(value="dispatches audit events in the method body")
    public SessionResponse newSession(@Context ContainerRequestContext requestContext, @ApiParam(name="Login request", value="Username and credentials", required=true) @Valid @NotNull SessionCreateRequest createRequest) {
        ImmutableMap auditEventContext;
        SecurityContext securityContext = requestContext.getSecurityContext();
        if (!(securityContext instanceof ShiroSecurityContext)) {
            throw new InternalServerErrorException("Unsupported SecurityContext class, this is a bug!");
        }
        ShiroSecurityContext shiroSecurityContext = (ShiroSecurityContext)securityContext;
        String sessionId = shiroSecurityContext.getUsername();
        Object id = null;
        if (sessionId != null && !sessionId.isEmpty()) {
            id = sessionId;
        }
        String remoteAddrFromRequest = RestTools.getRemoteAddrFromRequest(this.grizzlyRequest, this.trustedSubnets);
        Subject subject = new Subject.Builder().sessionId((Serializable)id).host(remoteAddrFromRequest).buildSubject();
        ThreadContext.bind((Subject)subject);
        Session s = subject.getSession();
        try {
            subject.login((AuthenticationToken)new UsernamePasswordToken(createRequest.username(), createRequest.password()));
            User user = this.userService.load(createRequest.username());
            if (user != null) {
                long timeoutInMillis = user.getSessionTimeoutMs();
                s.setTimeout(timeoutInMillis);
            } else {
                s.setTimeout(TimeUnit.HOURS.toMillis(8L));
            }
            s.touch();
            ((DefaultSecurityManager)SecurityUtils.getSecurityManager()).getSubjectDAO().save(subject);
        }
        catch (AuthenticationException e) {
            LOG.info("Invalid username or password for user \"{}\"", (Object)createRequest.username());
        }
        catch (UnknownSessionException e) {
            subject.logout();
        }
        if (subject.isAuthenticated()) {
            id = s.getId();
            auditEventContext = ImmutableMap.of((Object)"session_id", (Object)id, (Object)"remote_address", (Object)remoteAddrFromRequest);
            this.auditEventSender.success(AuditActor.user(createRequest.username()), "server:session:create", (Map<String, Object>)auditEventContext);
            return SessionResponse.create(new DateTime((Object)s.getLastAccessTime(), DateTimeZone.UTC).plus(s.getTimeout()).toDate(), id.toString());
        }
        auditEventContext = ImmutableMap.of((Object)"remote_address", (Object)remoteAddrFromRequest);
        this.auditEventSender.failure(AuditActor.user(createRequest.username()), "server:session:create", (Map<String, Object>)auditEventContext);
        throw new NotAuthorizedException("Invalid username or password", (Object)"Basic realm=\"Graylog Server session\"", new Object[0]);
    }

    @GET
    @ApiOperation(value="Validate an existing session", notes="Checks the session with the given ID: returns http status 204 (No Content) if session is valid.", code=204)
    public SessionValidationResponse validateSession(@Context ContainerRequestContext requestContext) {
        try {
            this.authenticationFilter.filter(requestContext);
        }
        catch (IOException | NotAuthorizedException | LockedAccountException e) {
            return SessionValidationResponse.invalid();
        }
        Subject subject = this.getSubject();
        if (!subject.isAuthenticated()) {
            return SessionValidationResponse.invalid();
        }
        if (subject.getSession(false) == null && ShiroSecurityContext.isSessionCreationRequested()) {
            Session session = subject.getSession();
            LOG.debug("Session created {}", (Object)session.getId());
            session.touch();
            ((DefaultSecurityManager)SecurityUtils.getSecurityManager()).getSubjectDAO().save(subject);
            return SessionValidationResponse.validWithNewSession(String.valueOf(session.getId()), String.valueOf(subject.getPrincipal()));
        }
        return SessionValidationResponse.valid();
    }

    @DELETE
    @ApiOperation(value="Terminate an existing session", notes="Destroys the session with the given ID: the equivalent of logging out.")
    @Path(value="/{sessionId}")
    @RequiresAuthentication
    @AuditEvent(type="server:session:delete")
    public void terminateSession(@ApiParam(name="sessionId", required=true) @PathParam(value="sessionId") String sessionId) {
        Subject subject = this.getSubject();
        this.securityManager.logout(subject);
    }
}

