/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system.authentication;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.shiro.realm.AuthenticatingRealm;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.security.AuthenticationConfig;
import org.graylog2.shared.rest.resources.RestResource;

@RequiresAuthentication
@Path(value="/system/authentication")
@Api(value="System/Authentication", description="Manage authentication providers")
@Produces(value={"application/json"})
public class AuthenticationResource
extends RestResource {
    private final ClusterConfigService clusterConfigService;
    private final Map<String, AuthenticatingRealm> availableRealms;

    @Inject
    public AuthenticationResource(ClusterConfigService clusterConfigService, Map<String, AuthenticatingRealm> availableRealms) {
        this.clusterConfigService = clusterConfigService;
        this.availableRealms = availableRealms;
    }

    @GET
    @Path(value="config")
    @ApiOperation(value="Retrieve authentication providers configuration")
    @RequiresPermissions(value={"clusterconfigentry:read"})
    public AuthenticationConfig getAuthenticators() {
        AuthenticationConfig config = this.clusterConfigService.getOrDefault(AuthenticationConfig.class, AuthenticationConfig.defaultInstance());
        return config.withRealms(this.availableRealms.keySet());
    }

    @PUT
    @Path(value="config")
    @ApiOperation(value="Update authentication providers configuration")
    @RequiresPermissions(value={"clusterconfigentry:read", "authentication:edit"})
    @AuditEvent(type="server:authentication_provider_configuration:update")
    public AuthenticationConfig create(@ApiParam(name="config", required=true) AuthenticationConfig config) {
        this.clusterConfigService.write(config);
        return this.clusterConfigService.getOrDefault(AuthenticationConfig.class, config);
    }
}

