/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.security.hashing;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import org.graylog2.plugin.security.PasswordAlgorithm;
import org.mindrot.jbcrypt.BCrypt;

public class BCryptPasswordAlgorithm
implements PasswordAlgorithm {
    private static final String PREFIX = "{bcrypt}";
    private static final String SALT_PREFIX = "{salt}";
    private final Integer saltSize;

    @Inject
    public BCryptPasswordAlgorithm(@Named(value="user_password_bcrypt_salt_size") Integer saltSize) {
        this.saltSize = saltSize;
    }

    @Override
    public boolean supports(String hashedPassword) {
        return hashedPassword.startsWith(PREFIX) && hashedPassword.contains(SALT_PREFIX);
    }

    private String hash(String password, String salt) {
        return PREFIX + BCrypt.hashpw((String)password, (String)salt) + SALT_PREFIX + salt;
    }

    @Override
    public String hash(String password) {
        return this.hash(password, BCrypt.gensalt((int)this.saltSize));
    }

    @Override
    public boolean matches(String hashedPasswordAndSalt, String otherPassword) {
        Preconditions.checkArgument((boolean)this.supports(hashedPasswordAndSalt), (Object)"Supplied hashed password is not supported, it does not start with {bcrypt} or does not contain a salt.");
        int saltIndex = hashedPasswordAndSalt.lastIndexOf(SALT_PREFIX);
        String salt = hashedPasswordAndSalt.substring(saltIndex + SALT_PREFIX.length());
        return this.hash(otherPassword, salt).equals(hashedPasswordAndSalt);
    }
}

