/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.utilities;

import java.net.UnknownHostException;

public class ExceptionUtils {
    public static Throwable getRootCause(Throwable t) {
        if (t == null) {
            return null;
        }
        Throwable rootCause = t;
        for (Throwable cause = rootCause.getCause(); cause != null && cause != rootCause; cause = cause.getCause()) {
            rootCause = cause;
        }
        return rootCause;
    }

    public static String formatMessageCause(Throwable t) {
        if (t == null) {
            return "Unknown cause";
        }
        StringBuilder causeMessage = new StringBuilder();
        if (t.getClass() == UnknownHostException.class) {
            causeMessage.append("Unknown host '");
            causeMessage.append(t.getMessage());
            causeMessage.append("'");
        } else {
            causeMessage.append(t.getMessage());
        }
        if (!t.getMessage().endsWith(".")) {
            causeMessage.append(".");
        }
        return causeMessage.toString();
    }

    public static String getRootCauseMessage(Throwable t) {
        return ExceptionUtils.formatMessageCause(ExceptionUtils.getRootCause(t));
    }
}

