/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.lookup;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.graylog2.lookup.AutoValue_LookupDefaultMultiValue;
import org.graylog2.lookup.AutoValue_LookupDefaultSingleValue;
import org.graylog2.lookup.LookupDefaultValue;

@JsonAutoDetect
@JsonDeserialize(builder=AutoValue_LookupDefaultSingleValue.Builder.class)
public abstract class LookupDefaultMultiValue
implements LookupDefaultValue {
    @Override
    @JsonProperty(value="value_string")
    public abstract String valueString();

    @Override
    @JsonProperty(value="value_type")
    public abstract LookupDefaultValue.Type valueType();

    @Override
    @JsonProperty(value="value")
    @Nullable
    public abstract Map<Object, Object> value();

    @Override
    public boolean isSet() {
        return this.valueType() != LookupDefaultValue.Type.NULL;
    }

    public static LookupDefaultMultiValue create(String valueString, LookupDefaultValue.Type valueType) {
        Map value;
        Objects.requireNonNull(valueString, "valueString cannot be null");
        Objects.requireNonNull(valueType, "valueType cannot be null");
        try {
            switch (valueType) {
                case OBJECT: {
                    value = (Map)OBJECT_MAPPER.readValue(valueString, (TypeReference)new TypeReference<Map<Object, Object>>(){});
                    break;
                }
                case NULL: {
                    value = null;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Could not convert <" + valueString + "> to multi value type <" + (Object)((Object)valueType) + ">");
                }
            }
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not parse JSON " + valueType.toString().toLowerCase(Locale.ENGLISH) + " value <" + valueString + ">", e);
        }
        return LookupDefaultMultiValue.builder().valueString(valueString).valueType(valueType).value(value).build();
    }

    public static Builder builder() {
        return new AutoValue_LookupDefaultMultiValue.Builder();
    }

    public abstract Builder toBuilder();

    public static abstract class Builder {
        @JsonProperty(value="value_string")
        public abstract Builder valueString(String var1);

        @JsonProperty(value="value_type")
        public abstract Builder valueType(LookupDefaultValue.Type var1);

        @JsonProperty(value="value")
        public abstract Builder value(@Nullable Map<Object, Object> var1);

        public abstract LookupDefaultMultiValue build();
    }
}

