/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system.indexer.requests;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Nullable;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.graylog2.plugin.indexer.retention.RetentionStrategyConfig;
import org.graylog2.plugin.indexer.rotation.RotationStrategyConfig;
import org.graylog2.rest.resources.system.indexer.requests.IndexSetUpdateRequest;
import org.hibernate.validator.constraints.NotBlank;

final class AutoValue_IndexSetUpdateRequest
extends IndexSetUpdateRequest {
    private final String title;
    private final String description;
    private final boolean isWritable;
    private final int shards;
    private final int replicas;
    private final String rotationStrategyClass;
    private final RotationStrategyConfig rotationStrategy;
    private final String retentionStrategyClass;
    private final RetentionStrategyConfig retentionStrategy;
    private final int indexOptimizationMaxNumSegments;
    private final boolean indexOptimizationDisabled;

    AutoValue_IndexSetUpdateRequest(String title, @Nullable String description, boolean isWritable, int shards, int replicas, String rotationStrategyClass, RotationStrategyConfig rotationStrategy, String retentionStrategyClass, RetentionStrategyConfig retentionStrategy, int indexOptimizationMaxNumSegments, boolean indexOptimizationDisabled) {
        if (title == null) {
            throw new NullPointerException("Null title");
        }
        this.title = title;
        this.description = description;
        this.isWritable = isWritable;
        this.shards = shards;
        this.replicas = replicas;
        if (rotationStrategyClass == null) {
            throw new NullPointerException("Null rotationStrategyClass");
        }
        this.rotationStrategyClass = rotationStrategyClass;
        if (rotationStrategy == null) {
            throw new NullPointerException("Null rotationStrategy");
        }
        this.rotationStrategy = rotationStrategy;
        if (retentionStrategyClass == null) {
            throw new NullPointerException("Null retentionStrategyClass");
        }
        this.retentionStrategyClass = retentionStrategyClass;
        if (retentionStrategy == null) {
            throw new NullPointerException("Null retentionStrategy");
        }
        this.retentionStrategy = retentionStrategy;
        this.indexOptimizationMaxNumSegments = indexOptimizationMaxNumSegments;
        this.indexOptimizationDisabled = indexOptimizationDisabled;
    }

    @Override
    @JsonProperty(value="title")
    @NotBlank
    public String title() {
        return this.title;
    }

    @Override
    @JsonProperty(value="description")
    @Nullable
    public String description() {
        return this.description;
    }

    @Override
    @JsonProperty(value="writable")
    public boolean isWritable() {
        return this.isWritable;
    }

    @Override
    @JsonProperty(value="shards")
    @Min(value=1L)
    public int shards() {
        return this.shards;
    }

    @Override
    @JsonProperty(value="replicas")
    @Min(value=0L)
    public int replicas() {
        return this.replicas;
    }

    @Override
    @JsonProperty(value="rotation_strategy_class")
    @NotNull
    public String rotationStrategyClass() {
        return this.rotationStrategyClass;
    }

    @Override
    @JsonProperty(value="rotation_strategy")
    @NotNull
    public RotationStrategyConfig rotationStrategy() {
        return this.rotationStrategy;
    }

    @Override
    @JsonProperty(value="retention_strategy_class")
    @NotNull
    public String retentionStrategyClass() {
        return this.retentionStrategyClass;
    }

    @Override
    @JsonProperty(value="retention_strategy")
    @NotNull
    public RetentionStrategyConfig retentionStrategy() {
        return this.retentionStrategy;
    }

    @Override
    @JsonProperty(value="index_optimization_max_num_segments")
    @Min(value=1L)
    public int indexOptimizationMaxNumSegments() {
        return this.indexOptimizationMaxNumSegments;
    }

    @Override
    @JsonProperty(value="index_optimization_disabled")
    public boolean indexOptimizationDisabled() {
        return this.indexOptimizationDisabled;
    }

    public String toString() {
        return "IndexSetUpdateRequest{title=" + this.title + ", description=" + this.description + ", isWritable=" + this.isWritable + ", shards=" + this.shards + ", replicas=" + this.replicas + ", rotationStrategyClass=" + this.rotationStrategyClass + ", rotationStrategy=" + this.rotationStrategy + ", retentionStrategyClass=" + this.retentionStrategyClass + ", retentionStrategy=" + this.retentionStrategy + ", indexOptimizationMaxNumSegments=" + this.indexOptimizationMaxNumSegments + ", indexOptimizationDisabled=" + this.indexOptimizationDisabled + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof IndexSetUpdateRequest) {
            IndexSetUpdateRequest that = (IndexSetUpdateRequest)o;
            return this.title.equals(that.title()) && (this.description == null ? that.description() == null : this.description.equals(that.description())) && this.isWritable == that.isWritable() && this.shards == that.shards() && this.replicas == that.replicas() && this.rotationStrategyClass.equals(that.rotationStrategyClass()) && this.rotationStrategy.equals(that.rotationStrategy()) && this.retentionStrategyClass.equals(that.retentionStrategyClass()) && this.retentionStrategy.equals(that.retentionStrategy()) && this.indexOptimizationMaxNumSegments == that.indexOptimizationMaxNumSegments() && this.indexOptimizationDisabled == that.indexOptimizationDisabled();
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.title.hashCode();
        h *= 1000003;
        h ^= this.description == null ? 0 : this.description.hashCode();
        h *= 1000003;
        h ^= this.isWritable ? 1231 : 1237;
        h *= 1000003;
        h ^= this.shards;
        h *= 1000003;
        h ^= this.replicas;
        h *= 1000003;
        h ^= this.rotationStrategyClass.hashCode();
        h *= 1000003;
        h ^= this.rotationStrategy.hashCode();
        h *= 1000003;
        h ^= this.retentionStrategyClass.hashCode();
        h *= 1000003;
        h ^= this.retentionStrategy.hashCode();
        h *= 1000003;
        h ^= this.indexOptimizationMaxNumSegments;
        h *= 1000003;
        return h ^= this.indexOptimizationDisabled ? 1231 : 1237;
    }
}

