/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.audit;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.util.List;
import javax.annotation.Nonnull;
import org.graylog2.audit.AutoValue_AuditEventType;

@JsonAutoDetect
@AutoValue
public abstract class AuditEventType {
    private static final String FIELD_NAMESPACE = "namespace";
    private static final String FIELD_OBJECT = "object";
    private static final String FIELD_ACTION = "action";
    private static final String ARGUMENT_ERROR = "Type string needs to be in the following format: <namespace>:<object>:<action> - given string: ";
    private static final Splitter SPLITTER = Splitter.on((String)":").limit(3);
    private static final Joiner JOINER = Joiner.on((String)":");

    @JsonProperty(value="namespace")
    public abstract String namespace();

    @JsonProperty(value="object")
    public abstract String object();

    @JsonProperty(value="action")
    public abstract String action();

    public String toTypeString() {
        return JOINER.join((Object)this.namespace(), (Object)this.object(), new Object[]{this.action()});
    }

    @JsonCreator
    public static AuditEventType create(@JsonProperty(value="namespace") String namespace, @JsonProperty(value="object") String object, @JsonProperty(value="action") String action) {
        return new AutoValue_AuditEventType(namespace, object, action);
    }

    public static AuditEventType create(@Nonnull String type) {
        if (Strings.isNullOrEmpty((String)type)) {
            throw new IllegalArgumentException(ARGUMENT_ERROR + type);
        }
        List strings = SPLITTER.splitToList((CharSequence)type);
        if (strings.size() < 3) {
            throw new IllegalArgumentException(ARGUMENT_ERROR + type);
        }
        String namespace = (String)strings.get(0);
        String object = (String)strings.get(1);
        String action = (String)strings.get(2);
        if (Strings.isNullOrEmpty((String)namespace) || Strings.isNullOrEmpty((String)object) || Strings.isNullOrEmpty((String)action)) {
            throw new IllegalArgumentException(ARGUMENT_ERROR + type);
        }
        return AuditEventType.create(namespace, object, action);
    }
}

