/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.filters;

import java.util.List;
import javax.inject.Inject;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.filters.MessageFilter;
import org.graylog2.plugin.streams.Stream;
import org.graylog2.streams.StreamRouter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamMatcherFilter
implements MessageFilter {
    private static final Logger LOG = LoggerFactory.getLogger(StreamMatcherFilter.class);
    private final StreamRouter streamRouter;

    @Inject
    public StreamMatcherFilter(StreamRouter streamRouter) {
        this.streamRouter = streamRouter;
    }

    @Override
    public boolean filter(Message msg) {
        List<Stream> streams = this.streamRouter.route(msg);
        msg.addStreams(streams);
        LOG.debug("Routed message <{}> to {} streams.", (Object)msg.getId(), (Object)streams.size());
        return false;
    }

    @Override
    public String getName() {
        return "StreamMatcher";
    }

    @Override
    public int getPriority() {
        return 40;
    }
}

