/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.searches;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSortedSet;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestResult;
import io.searchbox.core.MultiSearch;
import io.searchbox.core.MultiSearchResult;
import io.searchbox.core.Search;
import io.searchbox.core.SearchResult;
import io.searchbox.core.search.aggregation.CardinalityAggregation;
import io.searchbox.core.search.aggregation.ExtendedStatsAggregation;
import io.searchbox.core.search.aggregation.FilterAggregation;
import io.searchbox.core.search.aggregation.HistogramAggregation;
import io.searchbox.core.search.aggregation.MissingAggregation;
import io.searchbox.core.search.aggregation.TermsAggregation;
import io.searchbox.core.search.aggregation.ValueCountAggregation;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.elasticsearch.common.Strings;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.filter.FilterAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.graylog2.Configuration;
import org.graylog2.database.NotFoundException;
import org.graylog2.indexer.ElasticsearchException;
import org.graylog2.indexer.FieldTypeException;
import org.graylog2.indexer.IndexHelper;
import org.graylog2.indexer.IndexSet;
import org.graylog2.indexer.cluster.jest.JestUtils;
import org.graylog2.indexer.indices.Indices;
import org.graylog2.indexer.ranges.IndexRange;
import org.graylog2.indexer.ranges.IndexRangeService;
import org.graylog2.indexer.results.CountResult;
import org.graylog2.indexer.results.DateHistogramResult;
import org.graylog2.indexer.results.FieldHistogramResult;
import org.graylog2.indexer.results.FieldStatsResult;
import org.graylog2.indexer.results.HistogramResult;
import org.graylog2.indexer.results.ResultMessage;
import org.graylog2.indexer.results.ScrollResult;
import org.graylog2.indexer.results.TermsResult;
import org.graylog2.indexer.results.TermsStatsResult;
import org.graylog2.indexer.searches.SearchesConfig;
import org.graylog2.indexer.searches.Sorting;
import org.graylog2.indexer.searches.timeranges.TimeRanges;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;
import org.graylog2.plugin.streams.Stream;
import org.graylog2.streams.StreamService;
import org.joda.time.Period;

@Singleton
public class Searches {
    public static final String AGG_TERMS = "gl2_terms";
    public static final String AGG_STATS = "gl2_stats";
    public static final String AGG_TERMS_STATS = "gl2_termsstats";
    public static final String AGG_FILTER = "gl2_filter";
    public static final String AGG_HISTOGRAM = "gl2_histogram";
    public static final String AGG_EXTENDED_STATS = "gl2_extended_stats";
    public static final String AGG_CARDINALITY = "gl2_field_cardinality";
    public static final String AGG_VALUE_COUNT = "gl2_value_count";
    private static final Pattern filterStreamIdPattern = Pattern.compile("^(.+[^\\p{Alnum}])?streams:([\\p{XDigit}]+)");
    private final Configuration configuration;
    private final IndexRangeService indexRangeService;
    private final Timer esRequestTimer;
    private final Histogram esTimeRangeHistogram;
    private final Counter esTotalSearchesCounter;
    private final StreamService streamService;
    private final Indices indices;
    private final JestClient jestClient;
    private final ScrollResult.Factory scrollResultFactory;

    @Inject
    public Searches(Configuration configuration, IndexRangeService indexRangeService, MetricRegistry metricRegistry, StreamService streamService, Indices indices, JestClient jestClient, ScrollResult.Factory scrollResultFactory) {
        this.configuration = Objects.requireNonNull(configuration, "configuration");
        this.indexRangeService = Objects.requireNonNull(indexRangeService, "indexRangeService");
        this.esRequestTimer = metricRegistry.timer(MetricRegistry.name(Searches.class, (String[])new String[]{"elasticsearch", "requests"}));
        this.esTimeRangeHistogram = metricRegistry.histogram(MetricRegistry.name(Searches.class, (String[])new String[]{"elasticsearch", "ranges"}));
        this.esTotalSearchesCounter = metricRegistry.counter(MetricRegistry.name(Searches.class, (String[])new String[]{"elasticsearch", "total-searches"}));
        this.streamService = Objects.requireNonNull(streamService, "streamService");
        this.indices = Objects.requireNonNull(indices, "indices");
        this.jestClient = Objects.requireNonNull(jestClient, "jestClient");
        this.scrollResultFactory = Objects.requireNonNull(scrollResultFactory, "scrollResultFactory");
    }

    public CountResult count(String query, TimeRange range) {
        return this.count(query, range, null);
    }

    public CountResult count(String query, TimeRange range, String filter) {
        Set<String> affectedIndices = this.determineAffectedIndices(range, filter);
        if (affectedIndices.isEmpty()) {
            return CountResult.empty();
        }
        String searchSource = this.standardSearchRequest(query, 0, -1, range, filter, null, false).toString();
        Search search = ((Search.Builder)new Search.Builder(searchSource).addIndex(affectedIndices)).build();
        SearchResult searchResult = this.wrapInMultiSearch(search, () -> "Unable to perform count query");
        this.recordEsMetrics((JestResult)searchResult, range);
        return CountResult.create(searchResult.getTotal(), 0L);
    }

    public ScrollResult scroll(String query, TimeRange range, int limit, int offset, List<String> fields, String filter) {
        Set<String> affectedIndices = this.determineAffectedIndices(range, filter);
        Sorting sorting = new Sorting("_doc", Sorting.Direction.ASC);
        String searchQuery = filter == null ? this.standardSearchRequest(query, limit, offset, range, sorting).toString() : this.filteredSearchRequest(query, filter, limit, offset, range, sorting).toString();
        Search.Builder initialSearchBuilder = (Search.Builder)((Search.Builder)((Search.Builder)new Search.Builder(searchQuery).addType("message")).setParameter("scroll", (Object)"1m")).addIndex(affectedIndices);
        fields.forEach(arg_0 -> ((Search.Builder)initialSearchBuilder).addSourceIncludePattern(arg_0));
        SearchResult initialResult = this.wrapInMultiSearch(initialSearchBuilder.build(), () -> "Unable to perform scroll search");
        this.recordEsMetrics((JestResult)initialResult, range);
        return this.scrollResultFactory.create(initialResult, query, fields);
    }

    public org.graylog2.indexer.results.SearchResult search(String query, TimeRange range, int limit, int offset, Sorting sorting) {
        return this.search(query, null, range, limit, offset, sorting);
    }

    public org.graylog2.indexer.results.SearchResult search(String query, String filter, TimeRange range, int limit, int offset, Sorting sorting) {
        SearchesConfig searchesConfig = SearchesConfig.builder().query(query).filter(filter).range(range).limit(limit).offset(offset).sorting(sorting).build();
        return this.search(searchesConfig);
    }

    public org.graylog2.indexer.results.SearchResult search(SearchesConfig config) {
        Set<IndexRange> indexRanges = this.determineAffectedIndicesWithRanges(config.range(), config.filter());
        SearchSourceBuilder requestBuilder = this.searchRequest(config);
        if (indexRanges.isEmpty()) {
            return org.graylog2.indexer.results.SearchResult.empty(config.query(), requestBuilder.toString());
        }
        Set<String> indices = this.extractIndexNamesFromIndexRanges(indexRanges);
        Search.Builder searchBuilder = (Search.Builder)((Search.Builder)new Search.Builder(requestBuilder.toString()).addType("message")).addIndex(indices);
        SearchResult searchResult = this.wrapInMultiSearch(searchBuilder.build(), () -> "Unable to perform search query");
        List<ResultMessage> hits = searchResult.getHits(Map.class, false).stream().map(hit -> ResultMessage.parseFromSource(hit.id, hit.index, (Map)hit.source, hit.highlight)).collect(Collectors.toList());
        this.recordEsMetrics((JestResult)searchResult, config.range());
        return new org.graylog2.indexer.results.SearchResult(hits, searchResult.getTotal(), indexRanges, config.query(), requestBuilder.toString(), this.tookMsFromSearchResult((JestResult)searchResult));
    }

    public TermsResult terms(String field, int size, String query, String filter, TimeRange range, Sorting.Direction sorting) {
        Terms.Order termsOrder = sorting == Sorting.Direction.DESC ? Terms.Order.count((boolean)false) : Terms.Order.count((boolean)true);
        SearchSourceBuilder searchSourceBuilder = this.filteredSearchRequest(query, filter, range).aggregation((AbstractAggregationBuilder)((TermsBuilder)AggregationBuilders.terms((String)AGG_TERMS).field(field)).size(size > 0 ? size : 50).order(termsOrder)).aggregation((AbstractAggregationBuilder)AggregationBuilders.missing((String)"missing").field(field));
        Set<String> affectedIndices = this.determineAffectedIndices(range, filter);
        if (affectedIndices.isEmpty()) {
            return TermsResult.empty(query, searchSourceBuilder.toString());
        }
        Search.Builder searchBuilder = (Search.Builder)((Search.Builder)((Search.Builder)((Search.Builder)new Search.Builder(searchSourceBuilder.toString()).ignoreUnavailable(true)).allowNoIndices(true)).addType("message")).addIndex(affectedIndices);
        SearchResult searchResult = this.wrapInMultiSearch(searchBuilder.build(), () -> "Unable to perform terms query");
        this.recordEsMetrics((JestResult)searchResult, range);
        TermsAggregation termsAggregation = searchResult.getAggregations().getTermsAggregation(AGG_TERMS);
        MissingAggregation missing = searchResult.getAggregations().getMissingAggregation("missing");
        return new TermsResult(termsAggregation, missing.getMissing(), searchResult.getTotal(), query, searchSourceBuilder.toString(), this.tookMsFromSearchResult((JestResult)searchResult));
    }

    public TermsResult terms(String field, int size, String query, String filter, TimeRange range) {
        return this.terms(field, size, query, filter, range, Sorting.Direction.DESC);
    }

    public TermsResult terms(String field, int size, String query, TimeRange range) {
        return this.terms(field, size, query, null, range, Sorting.Direction.DESC);
    }

    public TermsStatsResult termsStats(String keyField, String valueField, TermsStatsOrder order, int size, String query, String filter, TimeRange range) {
        Terms.Order termsOrder;
        if (size == 0) {
            size = 50;
        }
        Set<String> affectedIndices = this.determineAffectedIndices(range, filter);
        SearchSourceBuilder searchSourceBuilder = filter == null ? this.standardSearchRequest(query, range) : this.filteredSearchRequest(query, filter, range);
        switch (order) {
            case COUNT: {
                termsOrder = Terms.Order.count((boolean)true);
                break;
            }
            case REVERSE_COUNT: {
                termsOrder = Terms.Order.count((boolean)false);
                break;
            }
            case TERM: {
                termsOrder = Terms.Order.term((boolean)true);
                break;
            }
            case REVERSE_TERM: {
                termsOrder = Terms.Order.term((boolean)false);
                break;
            }
            case MIN: {
                termsOrder = Terms.Order.aggregation((String)AGG_STATS, (String)"min", (boolean)true);
                break;
            }
            case REVERSE_MIN: {
                termsOrder = Terms.Order.aggregation((String)AGG_STATS, (String)"min", (boolean)false);
                break;
            }
            case MAX: {
                termsOrder = Terms.Order.aggregation((String)AGG_STATS, (String)"max", (boolean)true);
                break;
            }
            case REVERSE_MAX: {
                termsOrder = Terms.Order.aggregation((String)AGG_STATS, (String)"max", (boolean)false);
                break;
            }
            case MEAN: {
                termsOrder = Terms.Order.aggregation((String)AGG_STATS, (String)"avg", (boolean)true);
                break;
            }
            case REVERSE_MEAN: {
                termsOrder = Terms.Order.aggregation((String)AGG_STATS, (String)"avg", (boolean)false);
                break;
            }
            case TOTAL: {
                termsOrder = Terms.Order.aggregation((String)AGG_STATS, (String)"sum", (boolean)true);
                break;
            }
            case REVERSE_TOTAL: {
                termsOrder = Terms.Order.aggregation((String)AGG_STATS, (String)"sum", (boolean)false);
                break;
            }
            default: {
                termsOrder = Terms.Order.count((boolean)true);
            }
        }
        FilterAggregationBuilder builder = ((FilterAggregationBuilder)AggregationBuilders.filter((String)AGG_FILTER).subAggregation((AbstractAggregationBuilder)((TermsBuilder)((TermsBuilder)AggregationBuilders.terms((String)AGG_TERMS_STATS).field(keyField)).subAggregation((AbstractAggregationBuilder)AggregationBuilders.stats((String)AGG_STATS).field(valueField))).order(termsOrder).size(size))).filter(this.standardAggregationFilters(range, filter));
        searchSourceBuilder.aggregation((AbstractAggregationBuilder)builder);
        if (affectedIndices.isEmpty()) {
            return TermsStatsResult.empty(query, searchSourceBuilder.toString());
        }
        Search.Builder searchBuilder = (Search.Builder)((Search.Builder)new Search.Builder(searchSourceBuilder.toString()).addType("message")).addIndex(affectedIndices);
        SearchResult searchResult = this.wrapInMultiSearch(searchBuilder.build(), () -> "Unable to retrieve terms stats");
        FilterAggregation filterAggregation = searchResult.getAggregations().getFilterAggregation(AGG_FILTER);
        TermsAggregation termsAggregation = filterAggregation.getTermsAggregation(AGG_TERMS_STATS);
        this.recordEsMetrics((JestResult)searchResult, range);
        return new TermsStatsResult(termsAggregation, query, searchSourceBuilder.toString(), this.tookMsFromSearchResult((JestResult)searchResult));
    }

    public TermsStatsResult termsStats(String keyField, String valueField, TermsStatsOrder order, int size, String query, TimeRange range) {
        return this.termsStats(keyField, valueField, order, size, query, null, range);
    }

    public FieldStatsResult fieldStats(String field, String query, TimeRange range) {
        return this.fieldStats(field, query, null, range);
    }

    public FieldStatsResult fieldStats(String field, String query, String filter, TimeRange range) {
        return this.fieldStats(field, query, filter, range, true, true, true);
    }

    public FieldStatsResult fieldStats(String field, String query, String filter, TimeRange range, boolean includeCardinality, boolean includeStats, boolean includeCount) {
        SearchSourceBuilder searchSourceBuilder = filter == null ? this.standardSearchRequest(query, range) : this.filteredSearchRequest(query, filter, range);
        FilterAggregationBuilder filterBuilder = AggregationBuilders.filter((String)AGG_FILTER).filter(this.standardAggregationFilters(range, filter));
        if (includeCount) {
            searchSourceBuilder.aggregation((AbstractAggregationBuilder)AggregationBuilders.count((String)AGG_VALUE_COUNT).field(field));
        }
        if (includeStats) {
            searchSourceBuilder.aggregation((AbstractAggregationBuilder)AggregationBuilders.extendedStats((String)AGG_EXTENDED_STATS).field(field));
        }
        if (includeCardinality) {
            searchSourceBuilder.aggregation((AbstractAggregationBuilder)AggregationBuilders.cardinality((String)AGG_CARDINALITY).field(field));
        }
        searchSourceBuilder.aggregation((AbstractAggregationBuilder)filterBuilder);
        Set<String> indices = this.indicesContainingField(this.determineAffectedIndices(range, filter), field);
        if (indices.isEmpty()) {
            return FieldStatsResult.empty(query, searchSourceBuilder.toString());
        }
        Search searchRequest = ((Search.Builder)((Search.Builder)new Search.Builder(searchSourceBuilder.toString()).addType("message")).addIndex(indices)).build();
        SearchResult searchResponse = this.wrapInMultiSearch(searchRequest, () -> "Unable to retrieve fields stats");
        List<ResultMessage> hits = searchResponse.getHits(Map.class, false).stream().map(hit -> ResultMessage.parseFromSource(hit.id, hit.index, (Map)hit.source)).collect(Collectors.toList());
        this.recordEsMetrics((JestResult)searchResponse, range);
        ExtendedStatsAggregation extendedStatsAggregation = searchResponse.getAggregations().getExtendedStatsAggregation(AGG_EXTENDED_STATS);
        ValueCountAggregation valueCountAggregation = searchResponse.getAggregations().getValueCountAggregation(AGG_VALUE_COUNT);
        CardinalityAggregation cardinalityAggregation = searchResponse.getAggregations().getCardinalityAggregation(AGG_CARDINALITY);
        return new FieldStatsResult(valueCountAggregation, extendedStatsAggregation, cardinalityAggregation, hits, query, searchSourceBuilder.toString(), this.tookMsFromSearchResult((JestResult)searchResponse));
    }

    private Set<String> indicesContainingField(Set<String> strings, String field) {
        return this.indices.getAllMessageFieldsForIndices(strings.toArray(new String[strings.size()])).entrySet().stream().filter(entry -> ((Set)entry.getValue()).contains(field)).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public HistogramResult histogram(String query, DateHistogramInterval interval, TimeRange range) {
        return this.histogram(query, interval, null, range);
    }

    public HistogramResult histogram(String query, DateHistogramInterval interval, String filter, TimeRange range) {
        DateHistogramBuilder histogramBuilder = ((DateHistogramBuilder)AggregationBuilders.dateHistogram((String)AGG_HISTOGRAM).field("timestamp")).interval(interval.toESInterval());
        SearchSourceBuilder searchSourceBuilder = this.filteredSearchRequest(query, filter, range).aggregation((AbstractAggregationBuilder)histogramBuilder);
        Set<String> affectedIndices = this.determineAffectedIndices(range, filter);
        if (affectedIndices.isEmpty()) {
            return DateHistogramResult.empty(query, searchSourceBuilder.toString(), interval);
        }
        Search.Builder searchBuilder = (Search.Builder)((Search.Builder)((Search.Builder)((Search.Builder)new Search.Builder(searchSourceBuilder.toString()).addType("message")).addIndex(affectedIndices)).ignoreUnavailable(true)).allowNoIndices(true);
        SearchResult searchResult = this.wrapInMultiSearch(searchBuilder.build(), () -> "Unable to retrieve histogram");
        this.recordEsMetrics((JestResult)searchResult, range);
        HistogramAggregation histogramAggregation = searchResult.getAggregations().getHistogramAggregation(AGG_HISTOGRAM);
        return new DateHistogramResult(histogramAggregation, query, searchSourceBuilder.toString(), interval, this.tookMsFromSearchResult((JestResult)searchResult));
    }

    public HistogramResult fieldHistogram(String query, String field, DateHistogramInterval interval, String filter, TimeRange range, boolean includeCardinality) {
        return this.fieldHistogram(query, field, interval, filter, range, true, includeCardinality);
    }

    public HistogramResult fieldHistogram(String query, String field, DateHistogramInterval interval, String filter, TimeRange range, boolean includeStats, boolean includeCardinality) {
        DateHistogramBuilder dateHistogramBuilder = ((DateHistogramBuilder)AggregationBuilders.dateHistogram((String)AGG_HISTOGRAM).field("timestamp")).interval(interval.toESInterval());
        if (includeStats) {
            dateHistogramBuilder.subAggregation((AbstractAggregationBuilder)AggregationBuilders.stats((String)AGG_STATS).field(field));
        } else {
            dateHistogramBuilder.subAggregation((AbstractAggregationBuilder)AggregationBuilders.count((String)AGG_VALUE_COUNT).field(field));
        }
        if (includeCardinality) {
            dateHistogramBuilder.subAggregation((AbstractAggregationBuilder)AggregationBuilders.cardinality((String)AGG_CARDINALITY).field(field));
        }
        SearchSourceBuilder searchSourceBuilder = this.filteredSearchRequest(query, filter, range).aggregation((AbstractAggregationBuilder)dateHistogramBuilder);
        Set<String> affectedIndices = this.determineAffectedIndices(range, filter);
        if (affectedIndices.isEmpty()) {
            return FieldHistogramResult.empty(query, searchSourceBuilder.toString(), interval);
        }
        Search.Builder searchBuilder = (Search.Builder)((Search.Builder)new Search.Builder(searchSourceBuilder.toString()).addType("message")).addIndex(affectedIndices);
        SearchResult searchResult = this.wrapInMultiSearch(searchBuilder.build(), () -> "Unable to retrieve field histogram");
        this.recordEsMetrics((JestResult)searchResult, range);
        HistogramAggregation histogramAggregation = searchResult.getAggregations().getHistogramAggregation(AGG_HISTOGRAM);
        return new FieldHistogramResult(histogramAggregation, query, searchSourceBuilder.toString(), interval, this.tookMsFromSearchResult((JestResult)searchResult));
    }

    private <T extends JestResult> T checkForFailedShards(T result) throws FieldTypeException {
        JsonNode shards = result.getJsonObject().path("_shards");
        double failedShards = shards.path("failed").asDouble();
        if (failedShards > 0.0) {
            List<String> errors = StreamSupport.stream(shards.path("failures").spliterator(), false).map(failure -> failure.path("reason").path("reason").asText()).filter(s -> !s.isEmpty()).collect(Collectors.toList());
            List<String> nonNumericFieldErrors = errors.stream().filter(error -> error.startsWith("Expected numeric type on field")).collect(Collectors.toList());
            if (!nonNumericFieldErrors.isEmpty()) {
                throw new FieldTypeException("Unable to perform search query", nonNumericFieldErrors);
            }
            throw new ElasticsearchException("Unable to perform search query", errors);
        }
        return result;
    }

    private SearchSourceBuilder searchRequest(SearchesConfig config) {
        SearchSourceBuilder request = config.filter() == null ? this.standardSearchRequest(config.query(), config.limit(), config.offset(), config.range(), config.sorting()) : this.filteredSearchRequest(config.query(), config.filter(), config.limit(), config.offset(), config.range(), config.sorting());
        List<String> fields = config.fields();
        if (fields != null) {
            request.fetchSource(fields.toArray(new String[fields.size()]), Strings.EMPTY_ARRAY);
        }
        return request;
    }

    private SearchSourceBuilder standardSearchRequest(String query, TimeRange range) {
        return this.standardSearchRequest(query, 0, 0, range, null);
    }

    private SearchSourceBuilder standardSearchRequest(String query, int limit, int offset, TimeRange range, Sorting sort) {
        return this.standardSearchRequest(query, limit, offset, range, sort, true);
    }

    private SearchSourceBuilder standardSearchRequest(String query, int limit, int offset, TimeRange range, Sorting sort, boolean highlight) {
        return this.standardSearchRequest(query, limit, offset, range, null, sort, highlight);
    }

    private SearchSourceBuilder standardSearchRequest(String query, int limit, int offset, TimeRange range, String filter, Sorting sort, boolean highlight) {
        if (query == null || query.trim().isEmpty()) {
            query = "*";
        }
        Object queryBuilder = "*".equals(query.trim()) ? QueryBuilders.matchAllQuery() : QueryBuilders.queryStringQuery((String)query).allowLeadingWildcard(this.configuration.isAllowLeadingWildcardSearches());
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)queryBuilder).filter(this.standardFilters(range, filter)));
        if (offset >= 0) {
            searchSourceBuilder.from(offset);
        }
        if (limit > 0) {
            searchSourceBuilder.size(limit);
        }
        if (sort != null) {
            searchSourceBuilder.sort(sort.getField(), sort.asElastic());
        }
        if (highlight && this.configuration.isAllowHighlighting()) {
            searchSourceBuilder.highlighter().requireFieldMatch(false).field("*").fragmentSize(Integer.valueOf(0)).numOfFragments(Integer.valueOf(0));
        }
        return searchSourceBuilder;
    }

    private SearchSourceBuilder filteredSearchRequest(String query, String filter, TimeRange range) {
        return this.filteredSearchRequest(query, filter, 0, 0, range, null);
    }

    private SearchSourceBuilder filteredSearchRequest(String query, String filter, int limit, int offset, TimeRange range, Sorting sort) {
        return this.standardSearchRequest(query, limit, offset, range, filter, sort, true);
    }

    private long tookMsFromSearchResult(JestResult searchResult) {
        JsonNode tookMs = searchResult.getJsonObject().path("took");
        if (tookMs.isNumber()) {
            return tookMs.asLong();
        }
        throw new ElasticsearchException("Unexpected response structure: " + searchResult.getJsonString());
    }

    private void recordEsMetrics(JestResult jestResult, @Nullable TimeRange range) {
        this.esTotalSearchesCounter.inc();
        long tookMs = this.tookMsFromSearchResult(jestResult);
        this.esRequestTimer.update(tookMs, TimeUnit.MILLISECONDS);
        if (range != null) {
            this.esTimeRangeHistogram.update(TimeRanges.toSeconds(range));
        }
    }

    @Nullable
    private QueryBuilder standardFilters(TimeRange range, String filter) {
        BoolQueryBuilder bfb = null;
        if (range != null) {
            bfb = QueryBuilders.boolQuery();
            bfb.must(IndexHelper.getTimestampRangeFilter(range));
        }
        if (!com.google.common.base.Strings.isNullOrEmpty((String)filter) && !"*".equals(filter)) {
            if (bfb == null) {
                bfb = QueryBuilders.boolQuery();
            }
            bfb.must((QueryBuilder)QueryBuilders.queryStringQuery((String)filter));
        }
        return bfb;
    }

    private QueryBuilder standardAggregationFilters(TimeRange range, String filter) {
        QueryBuilder filterBuilder = this.standardFilters(range, filter);
        if (filterBuilder == null) {
            throw new RuntimeException("Either range or filter must be set.");
        }
        return filterBuilder;
    }

    public static Optional<String> extractStreamId(String filter) {
        if (com.google.common.base.Strings.isNullOrEmpty((String)filter)) {
            return Optional.empty();
        }
        Matcher streamIdMatcher = filterStreamIdPattern.matcher(filter);
        if (streamIdMatcher.find()) {
            return Optional.of(streamIdMatcher.group(2));
        }
        return Optional.empty();
    }

    @VisibleForTesting
    Set<String> determineAffectedIndices(TimeRange range, @Nullable String filter) {
        return this.extractIndexNamesFromIndexRanges(this.determineAffectedIndicesWithRanges(range, filter));
    }

    private Set<String> extractIndexNamesFromIndexRanges(Set<IndexRange> indexRanges) {
        return indexRanges.stream().map(IndexRange::indexName).collect(Collectors.toSet());
    }

    @VisibleForTesting
    Set<IndexRange> determineAffectedIndicesWithRanges(TimeRange range, @Nullable String filter) {
        Optional<String> streamId = Searches.extractStreamId(filter);
        IndexSet indexSet = null;
        if (streamId.isPresent()) {
            try {
                Stream stream = this.streamService.load(streamId.get());
                indexSet = stream.getIndexSet();
            }
            catch (NotFoundException stream) {
                // empty catch block
            }
        }
        ImmutableSortedSet.Builder indices = ImmutableSortedSet.orderedBy(IndexRange.COMPARATOR);
        SortedSet<IndexRange> indexRanges = this.indexRangeService.find(range.getFrom(), range.getTo());
        for (IndexRange indexRange : indexRanges) {
            boolean streamInCurrentIndexSet;
            if (indexSet == null && filter == null) {
                indices.add((Object)indexRange);
                continue;
            }
            boolean streamInIndexRange = streamId.isPresent() && indexRange.streamIds() != null && indexRange.streamIds().contains(streamId.get());
            boolean bl = streamInCurrentIndexSet = indexSet != null && indexSet.isManagedIndex(indexRange.indexName());
            if (streamInIndexRange) {
                indices.add((Object)indexRange);
            }
            if (!streamInCurrentIndexSet) continue;
            indices.add((Object)indexRange);
        }
        return indices.build();
    }

    private SearchResult wrapInMultiSearch(Search search, Supplier<String> errorMessage) {
        MultiSearch multiSearch = new MultiSearch.Builder(search).build();
        MultiSearchResult multiSearchResult = (MultiSearchResult)JestUtils.execute(this.jestClient, multiSearch, errorMessage);
        List responses = multiSearchResult.getResponses();
        if (responses.size() != 1) {
            throw new ElasticsearchException("Expected exactly 1 search result, but got " + responses.size());
        }
        MultiSearchResult.MultiSearchResponse response = (MultiSearchResult.MultiSearchResponse)responses.get(0);
        if (response.isError) {
            throw JestUtils.specificException(errorMessage, response.error);
        }
        return this.checkForFailedShards(response.searchResult);
    }

    public static enum DateHistogramInterval {
        YEAR(Period.years((int)1)),
        QUARTER(Period.months((int)3)),
        MONTH(Period.months((int)1)),
        WEEK(Period.weeks((int)1)),
        DAY(Period.days((int)1)),
        HOUR(Period.hours((int)1)),
        MINUTE(Period.minutes((int)1));

        private final Period period;

        private DateHistogramInterval(Period period) {
            this.period = period;
        }

        public Period getPeriod() {
            return this.period;
        }

        public org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval toESInterval() {
            switch (this) {
                case MINUTE: {
                    return org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval.MINUTE;
                }
                case HOUR: {
                    return org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval.HOUR;
                }
                case DAY: {
                    return org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval.DAY;
                }
                case WEEK: {
                    return org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval.WEEK;
                }
                case MONTH: {
                    return org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval.MONTH;
                }
                case QUARTER: {
                    return org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval.QUARTER;
                }
            }
            return org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval.YEAR;
        }
    }

    public static enum TermsStatsOrder {
        TERM,
        REVERSE_TERM,
        COUNT,
        REVERSE_COUNT,
        TOTAL,
        REVERSE_TOTAL,
        MIN,
        REVERSE_MIN,
        MAX,
        REVERSE_MAX,
        MEAN,
        REVERSE_MEAN;

    }
}

