/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.lookup.adapters.dsvhttp;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class HTTPFileRetriever {
    private final AtomicReference<Map<String, String>> lastLastModified = new AtomicReference(Collections.emptyMap());
    private final OkHttpClient client;

    @Inject
    public HTTPFileRetriever(OkHttpClient httpClient) {
        this.client = httpClient.newBuilder().followRedirects(true).followSslRedirects(true).build();
    }

    public Optional<String> fetchFileIfNotModified(String url) throws IOException {
        Call request;
        Response response;
        Request.Builder requestBuilder = new Request.Builder().get().url(url).header("User-Agent", "Graylog (server)");
        String lastModified = this.lastLastModified.get().get(url);
        if (lastModified != null) {
            requestBuilder.header("If-Modified-Since", lastModified);
        }
        if ((response = (request = this.client.newCall(requestBuilder.build())).execute()).isSuccessful()) {
            String lastModifiedHeader = response.header("Last-Modified", DateTime.now((DateTimeZone)DateTimeZone.UTC).toString());
            HashMap<String, String> newLastModified = new HashMap<String, String>(this.lastLastModified.get());
            newLastModified.put(url, lastModifiedHeader);
            this.lastLastModified.set((Map<String, String>)ImmutableMap.copyOf(newLastModified));
            if (response.body() != null) {
                String body = response.body().string();
                return body == null ? Optional.empty() : Optional.of(body);
            }
        } else if (response.code() != 304) {
            throw new IOException("Request failed: " + response.message());
        }
        return Optional.empty();
    }
}

