/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.messageprocessors;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.graylog2.messageprocessors.;

@JsonAutoDetect
@AutoValue
public abstract class MessageProcessorsConfig {
    @JsonProperty(value="processor_order")
    public abstract List<String> processorOrder();

    @JsonProperty(value="disabled_processors")
    public abstract Set<String> disabledProcessors();

    @JsonCreator
    public static MessageProcessorsConfig create(@JsonProperty(value="processor_order") List<String> processorOrder, @JsonProperty(value="disabled_processors") Set<String> disabledProcessors) {
        return MessageProcessorsConfig.builder().processorOrder(processorOrder).disabledProcessors(disabledProcessors).build();
    }

    public static MessageProcessorsConfig create(List<String> processorOrder) {
        return MessageProcessorsConfig.builder().processorOrder(processorOrder).disabledProcessors(Collections.emptySet()).build();
    }

    public static MessageProcessorsConfig defaultConfig() {
        return MessageProcessorsConfig.builder().processorOrder(Collections.emptyList()).disabledProcessors(Collections.emptySet()).build();
    }

    public static Builder builder() {
        return new .AutoValue_MessageProcessorsConfig.Builder();
    }

    public abstract Builder toBuilder();

    public MessageProcessorsConfig withProcessors(Set<String> availableProcessors) {
        ArrayList<String> newOrder = new ArrayList<String>();
        this.processorOrder().stream().filter(availableProcessors::contains).forEach(newOrder::add);
        availableProcessors.stream().filter(processor -> !newOrder.contains(processor)).sorted(String.CASE_INSENSITIVE_ORDER).forEach(newOrder::add);
        return this.toBuilder().processorOrder(newOrder).build();
    }

    public static abstract class Builder {
        public abstract Builder processorOrder(List<String> var1);

        public abstract Builder disabledProcessors(Set<String> var1);

        public abstract MessageProcessorsConfig build();
    }
}

