/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.migrations;

import com.google.common.collect.ImmutableMap;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.Map;
import javax.inject.Inject;
import org.bson.types.ObjectId;
import org.graylog2.database.NotFoundException;
import org.graylog2.events.ClusterEventBus;
import org.graylog2.indexer.IndexSet;
import org.graylog2.indexer.IndexSetRegistry;
import org.graylog2.migrations.Migration;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.plugin.streams.Stream;
import org.graylog2.streams.StreamImpl;
import org.graylog2.streams.StreamService;
import org.graylog2.streams.events.StreamsChangedEvent;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V20161116172200_CreateDefaultStreamMigration
extends Migration {
    private static final Logger LOG = LoggerFactory.getLogger(V20161116172200_CreateDefaultStreamMigration.class);
    private final StreamService streamService;
    private final ClusterEventBus clusterEventBus;
    private final IndexSetRegistry indexSetRegistry;

    @Inject
    public V20161116172200_CreateDefaultStreamMigration(StreamService streamService, ClusterEventBus clusterEventBus, IndexSetRegistry indexSetRegistry) {
        this.streamService = streamService;
        this.clusterEventBus = clusterEventBus;
        this.indexSetRegistry = indexSetRegistry;
    }

    @Override
    public ZonedDateTime createdAt() {
        return ZonedDateTime.parse("2016-11-16T17:22:00Z");
    }

    @Override
    public void upgrade() {
        try {
            this.streamService.load("000000000000000000000001");
        }
        catch (NotFoundException ignored) {
            this.createDefaultStream();
        }
    }

    private void createDefaultStream() {
        IndexSet indexSet = this.indexSetRegistry.getDefault();
        ObjectId id = new ObjectId("000000000000000000000001");
        ImmutableMap fields = ImmutableMap.builder().put((Object)"title", (Object)"All messages").put((Object)"description", (Object)"Stream containing all messages").put((Object)"disabled", (Object)false).put((Object)"created_at", (Object)DateTime.now((DateTimeZone)DateTimeZone.UTC)).put((Object)"creator_user_id", (Object)"local:admin").put((Object)"matching_type", (Object)Stream.MatchingType.DEFAULT.name()).put((Object)"remove_matches_from_default_stream", (Object)false).put((Object)"is_default_stream", (Object)true).put((Object)"index_set_id", (Object)indexSet.getConfig().id()).build();
        StreamImpl stream = new StreamImpl(id, (Map<String, Object>)fields, Collections.emptyList(), Collections.emptySet(), indexSet);
        try {
            this.streamService.save(stream);
            LOG.info("Successfully created default stream: {}", (Object)stream.getTitle());
        }
        catch (ValidationException e) {
            LOG.error("Couldn't create default stream! This is a bug!");
        }
        this.clusterEventBus.post(StreamsChangedEvent.create(stream.getId()));
    }
}

